/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.sdk.kafka;

import java.util.Objects;
import java.util.Properties;
import org.apache.flink.statefun.sdk.EgressType;
import org.apache.flink.statefun.sdk.io.EgressIdentifier;
import org.apache.flink.statefun.sdk.io.EgressSpec;
import org.apache.flink.statefun.sdk.kafka.Constants;
import org.apache.flink.statefun.sdk.kafka.KafkaEgressSerializer;
import org.apache.flink.statefun.sdk.kafka.KafkaProducerSemantic;

public final class KafkaEgressSpec<OutT>
implements EgressSpec<OutT> {
    private final Class<? extends KafkaEgressSerializer<OutT>> serializer;
    private final String kafkaAddress;
    private final Properties properties;
    private final EgressIdentifier<OutT> id;
    private final int kafkaProducerPoolSize;
    private final KafkaProducerSemantic semantic;

    KafkaEgressSpec(EgressIdentifier<OutT> id, Class<? extends KafkaEgressSerializer<OutT>> serializer, String kafkaAddress, Properties properties, int kafkaProducerPoolSize, KafkaProducerSemantic semantic) {
        this.serializer = Objects.requireNonNull(serializer);
        this.kafkaAddress = Objects.requireNonNull(kafkaAddress);
        this.properties = Objects.requireNonNull(properties);
        this.id = Objects.requireNonNull(id);
        this.kafkaProducerPoolSize = kafkaProducerPoolSize;
        this.semantic = Objects.requireNonNull(semantic);
    }

    public EgressIdentifier<OutT> id() {
        return this.id;
    }

    public EgressType type() {
        return Constants.KAFKA_EGRESS_TYPE;
    }

    public Class<? extends KafkaEgressSerializer<OutT>> serializerClass() {
        return this.serializer;
    }

    public String kafkaAddress() {
        return this.kafkaAddress;
    }

    public Properties properties() {
        return this.properties;
    }

    public int kafkaProducerPoolSize() {
        return this.kafkaProducerPoolSize;
    }

    public KafkaProducerSemantic semantic() {
        return this.semantic;
    }
}

