/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.sdk.kafka;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.flink.statefun.sdk.io.EgressIdentifier;
import org.apache.flink.statefun.sdk.kafka.KafkaEgressSerializer;
import org.apache.flink.statefun.sdk.kafka.KafkaEgressSpec;
import org.apache.flink.statefun.sdk.kafka.KafkaProducerSemantic;

public final class KafkaEgressBuilder<OutT> {
    private final EgressIdentifier<OutT> id;
    private Class<? extends KafkaEgressSerializer<OutT>> serializer;
    private String kafkaAddress;
    private Properties properties = new Properties();
    private int kafkaProducerPoolSize = 5;
    private KafkaProducerSemantic semantic = KafkaProducerSemantic.atLeastOnce();

    private KafkaEgressBuilder(EgressIdentifier<OutT> id) {
        this.id = Objects.requireNonNull(id);
    }

    public static <OutT> KafkaEgressBuilder<OutT> forIdentifier(EgressIdentifier<OutT> egressIdentifier) {
        return new KafkaEgressBuilder<OutT>(egressIdentifier);
    }

    public KafkaEgressBuilder<OutT> withKafkaAddress(String kafkaAddress) {
        this.kafkaAddress = Objects.requireNonNull(kafkaAddress);
        return this;
    }

    public KafkaEgressBuilder<OutT> withProperty(String key, String value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.properties.setProperty(key, value);
        return this;
    }

    public KafkaEgressBuilder<OutT> withProperties(Properties properties) {
        Objects.requireNonNull(properties);
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }

    public KafkaEgressBuilder<OutT> withSerializer(Class<? extends KafkaEgressSerializer<OutT>> serializer) {
        this.serializer = Objects.requireNonNull(serializer);
        return this;
    }

    public KafkaEgressBuilder<OutT> withKafkaProducerPoolSize(int poolSize) {
        this.kafkaProducerPoolSize = poolSize;
        return this;
    }

    public KafkaEgressBuilder<OutT> withExactlyOnceProducerSemantics(Duration transactionTimeoutDuration) {
        this.semantic = KafkaProducerSemantic.exactlyOnce(transactionTimeoutDuration);
        return this;
    }

    public KafkaEgressBuilder<OutT> withAtLeastOnceProducerSemantics() {
        this.semantic = KafkaProducerSemantic.atLeastOnce();
        return this;
    }

    public KafkaEgressBuilder<OutT> withNoProducerSemantics() {
        this.semantic = KafkaProducerSemantic.none();
        return this;
    }

    public KafkaEgressBuilder<OutT> withProducerSemantic(KafkaProducerSemantic producerSemantic) {
        this.semantic = Objects.requireNonNull(producerSemantic);
        return this;
    }

    public KafkaEgressSpec<OutT> build() {
        return new KafkaEgressSpec<OutT>(this.id, this.serializer, this.kafkaAddress, this.properties, this.kafkaProducerPoolSize, this.semantic);
    }
}

