/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.extensions;

import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.statefun.extensions.ComponentJsonFormatException;
import org.apache.flink.statefun.sdk.TypeName;

@PublicEvolving
public final class ComponentJsonObject {
    public static final String BINDER_KIND_FIELD = "kind";
    public static final String SPEC_FIELD = "spec";
    private final ObjectNode rawObjectNode;
    private final TypeName binderTypename;
    private final JsonNode specJsonNode;

    public ComponentJsonObject(JsonNode jsonNode) {
        Objects.requireNonNull(jsonNode);
        ComponentJsonObject.checkIsObject(jsonNode);
        this.rawObjectNode = (ObjectNode)jsonNode;
        this.binderTypename = ComponentJsonObject.parseBinderTypename(this.rawObjectNode);
        this.specJsonNode = ComponentJsonObject.extractSpecJsonNode(this.rawObjectNode);
    }

    public ObjectNode get() {
        return this.rawObjectNode;
    }

    public TypeName binderTypename() {
        return this.binderTypename;
    }

    public JsonNode specJsonNode() {
        return this.specJsonNode;
    }

    public String toString() {
        return this.rawObjectNode.toString();
    }

    private static void checkIsObject(JsonNode jsonNode) {
        if (!jsonNode.isObject()) {
            ComponentJsonObject.throwExceptionWithFormatHint();
        }
    }

    private static TypeName parseBinderTypename(ObjectNode componentObject) {
        JsonNode binderKindObject = componentObject.get(BINDER_KIND_FIELD);
        if (binderKindObject == null) {
            ComponentJsonObject.throwExceptionWithFormatHint();
        }
        try {
            return TypeName.parseFrom((String)binderKindObject.asText());
        }
        catch (Exception e) {
            throw new ComponentJsonFormatException("Invalid binder kind format.", e);
        }
    }

    private static JsonNode extractSpecJsonNode(ObjectNode componentObject) {
        JsonNode specJsonNode = componentObject.get(SPEC_FIELD);
        if (specJsonNode == null) {
            ComponentJsonObject.throwExceptionWithFormatHint();
        }
        return specJsonNode;
    }

    private static void throwExceptionWithFormatHint() {
        throw new ComponentJsonFormatException("Invalid ComponentJsonObject; components should be a JSON object with the required fields [kind] and [spec].");
    }
}

