/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.io.IOException;
import org.apache.flink.util.FlinkException;
import org.apache.flink.yarn.YarnClusterInformationRetriever;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.YarnException;

public final class YarnClientYarnClusterInformationRetriever
implements YarnClusterInformationRetriever {
    private final YarnClient yarnClient;

    private YarnClientYarnClusterInformationRetriever(YarnClient yarnClient) {
        this.yarnClient = yarnClient;
    }

    @Override
    public int getMaxVcores() throws FlinkException {
        try {
            return this.yarnClient.getNodeReports(new NodeState[]{NodeState.RUNNING}).stream().mapToInt(report -> report.getCapability().getVirtualCores()).max().orElse(0);
        }
        catch (IOException | YarnException e) {
            throw new FlinkException("Couldn't get cluster description, please check on the YarnConfiguration", e);
        }
    }

    public static YarnClientYarnClusterInformationRetriever create(YarnClient yarnClient) {
        return new YarnClientYarnClusterInformationRetriever(yarnClient);
    }
}

