/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.walkthrough.common.source;

import java.sql.Timestamp;
import java.util.Iterator;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.GenericInputFormat;
import org.apache.flink.api.common.io.NonParallelInput;
import org.apache.flink.core.io.GenericInputSplit;
import org.apache.flink.types.Row;
import org.apache.flink.walkthrough.common.entity.Transaction;
import org.apache.flink.walkthrough.common.source.TransactionIterator;

@Internal
public class TransactionRowInputFormat
extends GenericInputFormat<Row>
implements NonParallelInput {
    private static final long serialVersionUID = 1L;
    private transient Iterator<Transaction> transactions;

    public void open(GenericInputSplit split) {
        this.transactions = TransactionIterator.bounded();
    }

    public boolean reachedEnd() {
        return !this.transactions.hasNext();
    }

    public Row nextRecord(Row reuse) {
        Transaction transaction = this.transactions.next();
        reuse.setField(0, (Object)transaction.getAccountId());
        reuse.setField(1, (Object)new Timestamp(transaction.getTimestamp()));
        reuse.setField(2, (Object)transaction.getAmount());
        return reuse;
    }
}

