/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.state.operator.restore.unkeyed;

import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.test.state.operator.restore.AbstractOperatorRestoreTestBase;
import org.apache.flink.test.state.operator.restore.ExecutionMode;
import org.apache.flink.test.state.operator.restore.unkeyed.NonKeyedJob;
import org.apache.flink.testutils.migration.MigrationVersion;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class AbstractNonKeyedOperatorRestoreTestBase
extends AbstractOperatorRestoreTestBase {
    private final MigrationVersion migrationVersion;

    @Parameterized.Parameters(name="Migrate Savepoint: {0}")
    public static Collection<MigrationVersion> parameters() {
        return Arrays.asList(MigrationVersion.v1_2, MigrationVersion.v1_3, MigrationVersion.v1_4, MigrationVersion.v1_5, MigrationVersion.v1_6, MigrationVersion.v1_7, MigrationVersion.v1_8);
    }

    protected AbstractNonKeyedOperatorRestoreTestBase(MigrationVersion migrationVersion) {
        this.migrationVersion = migrationVersion;
    }

    protected AbstractNonKeyedOperatorRestoreTestBase(MigrationVersion migrationVersion, boolean allowNonRestoredState) {
        super(allowNonRestoredState);
        this.migrationVersion = migrationVersion;
    }

    @Override
    public void createMigrationJob(StreamExecutionEnvironment env) {
        SingleOutputStreamOperator<Integer> source = NonKeyedJob.createSource(env, ExecutionMode.MIGRATE);
        SingleOutputStreamOperator<Integer> first = NonKeyedJob.createFirstStatefulMap(ExecutionMode.MIGRATE, source);
        first.startNewChain();
        SingleOutputStreamOperator<Integer> second = NonKeyedJob.createSecondStatefulMap(ExecutionMode.MIGRATE, first);
        second.startNewChain();
        SingleOutputStreamOperator<Integer> stateless = NonKeyedJob.createStatelessMap(second);
        SingleOutputStreamOperator<Integer> third = NonKeyedJob.createThirdStatefulMap(ExecutionMode.MIGRATE, stateless);
    }

    @Override
    protected String getMigrationSavepointName() {
        return "nonKeyed-flink" + this.migrationVersion;
    }
}

