/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recovery;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HeartbeatManagerOptions;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.entrypoint.StandaloneSessionClusterEntrypoint;
import org.apache.flink.runtime.taskexecutor.TaskManagerRunner;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.apache.flink.runtime.util.BlobServerResource;
import org.apache.flink.runtime.zookeeper.ZooKeeperResource;
import org.apache.flink.test.util.TestProcessBuilder;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTaskManagerProcessFailureRecoveryTest
extends TestLogger {
    protected static final String READY_MARKER_FILE_PREFIX = "ready_";
    protected static final String PROCEED_MARKER_FILE = "proceed";
    protected static final int PARALLELISM = 4;
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public final BlobServerResource blobServerResource = new BlobServerResource();
    @Rule
    public final ZooKeeperResource zooKeeperResource = new ZooKeeperResource();

    @Test
    public void testTaskManagerProcessFailure() throws Exception {
        block35: {
            TestProcessBuilder.TestProcess taskManagerProcess3;
            TestProcessBuilder.TestProcess taskManagerProcess2;
            TestProcessBuilder.TestProcess taskManagerProcess1;
            block34: {
                taskManagerProcess1 = null;
                taskManagerProcess2 = null;
                taskManagerProcess3 = null;
                File coordinateTempDir = null;
                final Configuration config = new Configuration();
                config.setString(AkkaOptions.ASK_TIMEOUT, "100 s");
                config.setString(JobManagerOptions.ADDRESS, "localhost");
                config.setString(RestOptions.BIND_PORT, "0");
                config.setLong(HeartbeatManagerOptions.HEARTBEAT_INTERVAL, 500L);
                config.setLong(HeartbeatManagerOptions.HEARTBEAT_TIMEOUT, 10000L);
                config.setString(HighAvailabilityOptions.HA_MODE, "zookeeper");
                config.setString(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, this.zooKeeperResource.getConnectString());
                config.setString(HighAvailabilityOptions.HA_STORAGE_PATH, this.temporaryFolder.newFolder().getAbsolutePath());
                config.setInteger(TaskManagerOptions.NUM_TASK_SLOTS, 2);
                config.setString(TaskManagerOptions.MANAGED_MEMORY_SIZE, "4m");
                config.setInteger(NettyShuffleEnvironmentOptions.NETWORK_NUM_BUFFERS, 100);
                try {
                    try (StandaloneSessionClusterEntrypoint clusterEntrypoint = new StandaloneSessionClusterEntrypoint(config);){
                        Throwable error;
                        String javaCommand = CommonTestUtils.getJavaCommandPath();
                        if (javaCommand == null) {
                            System.out.println("---- Skipping Process Failure test : Could not find java executable ----");
                            return;
                        }
                        clusterEntrypoint.startCluster();
                        coordinateTempDir = this.temporaryFolder.newFolder();
                        TestProcessBuilder taskManagerProcessBuilder = new TestProcessBuilder(TaskExecutorProcessEntryPoint.class.getName());
                        taskManagerProcessBuilder.addConfigAsMainClassArgs(config);
                        taskManagerProcess1 = taskManagerProcessBuilder.start();
                        taskManagerProcess2 = taskManagerProcessBuilder.start();
                        final File coordinateDirClosure = coordinateTempDir;
                        final AtomicReference errorRef = new AtomicReference();
                        Thread programTrigger = new Thread("Program Trigger"){

                            @Override
                            public void run() {
                                try {
                                    AbstractTaskManagerProcessFailureRecoveryTest.this.testTaskManagerFailure(config, coordinateDirClosure);
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                    errorRef.set(t);
                                }
                            }
                        };
                        programTrigger.start();
                        if (!AbstractTaskManagerProcessFailureRecoveryTest.waitForMarkerFiles(coordinateTempDir, READY_MARKER_FILE_PREFIX, 4, 120000L)) {
                            if (errorRef.get() != null) {
                                error = (Throwable)errorRef.get();
                                error.printStackTrace();
                                Assert.fail((String)("The program encountered a " + error.getClass().getSimpleName() + " : " + error.getMessage()));
                            } else {
                                Assert.fail((String)"The tasks were not started within time (120000msecs)");
                            }
                        }
                        taskManagerProcess3 = taskManagerProcessBuilder.start();
                        taskManagerProcess1.destroy();
                        this.waitForShutdown("TaskManager 1", taskManagerProcess1);
                        AbstractTaskManagerProcessFailureRecoveryTest.touchFile(new File(coordinateTempDir, PROCEED_MARKER_FILE));
                        programTrigger.join(300000L);
                        Assert.assertFalse((String)"The program did not finish in time", (boolean)programTrigger.isAlive());
                        if (errorRef.get() != null) {
                            error = (Throwable)errorRef.get();
                            error.printStackTrace();
                            Assert.fail((String)("The program encountered a " + error.getClass().getSimpleName() + " : " + error.getMessage()));
                        }
                    }
                    if (taskManagerProcess1 == null) break block34;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    AbstractTaskManagerProcessFailureRecoveryTest.printProcessLog("TaskManager 1", taskManagerProcess1);
                    AbstractTaskManagerProcessFailureRecoveryTest.printProcessLog("TaskManager 2", taskManagerProcess2);
                    AbstractTaskManagerProcessFailureRecoveryTest.printProcessLog("TaskManager 3", taskManagerProcess3);
                    Assert.fail((String)e.getMessage());
                    break block35;
                }
                catch (Error e) {
                    e.printStackTrace();
                    AbstractTaskManagerProcessFailureRecoveryTest.printProcessLog("TaskManager 1", taskManagerProcess1);
                    AbstractTaskManagerProcessFailureRecoveryTest.printProcessLog("TaskManager 2", taskManagerProcess2);
                    AbstractTaskManagerProcessFailureRecoveryTest.printProcessLog("TaskManager 3", taskManagerProcess3);
                    throw e;
                }
                finally {
                    if (taskManagerProcess1 != null) {
                        taskManagerProcess1.destroy();
                    }
                    if (taskManagerProcess2 != null) {
                        taskManagerProcess2.destroy();
                    }
                    if (taskManagerProcess3 != null) {
                        taskManagerProcess3.destroy();
                    }
                    this.waitForShutdown("TaskManager 1", taskManagerProcess1);
                    this.waitForShutdown("TaskManager 2", taskManagerProcess2);
                    this.waitForShutdown("TaskManager 3", taskManagerProcess3);
                }
                taskManagerProcess1.destroy();
            }
            if (taskManagerProcess2 != null) {
                taskManagerProcess2.destroy();
            }
            if (taskManagerProcess3 != null) {
                taskManagerProcess3.destroy();
            }
            this.waitForShutdown("TaskManager 1", taskManagerProcess1);
            this.waitForShutdown("TaskManager 2", taskManagerProcess2);
            this.waitForShutdown("TaskManager 3", taskManagerProcess3);
        }
    }

    private void waitForShutdown(String processName, @Nullable TestProcessBuilder.TestProcess process) throws InterruptedException {
        if (process == null) {
            return;
        }
        if (!process.getProcess().waitFor(30L, TimeUnit.SECONDS)) {
            this.log.error("{} did not shutdown in time.", (Object)processName);
            AbstractTaskManagerProcessFailureRecoveryTest.printProcessLog(processName, process);
            process.getProcess().destroyForcibly();
        }
    }

    public abstract void testTaskManagerFailure(Configuration var1, File var2) throws Exception;

    protected static void printProcessLog(String processName, TestProcessBuilder.TestProcess process) {
        if (process == null) {
            System.out.println("-----------------------------------------");
            System.out.println(" PROCESS " + processName + " WAS NOT STARTED.");
            System.out.println("-----------------------------------------");
        } else {
            System.out.println("-----------------------------------------");
            System.out.println(" BEGIN SPAWNED PROCESS LOG FOR " + processName);
            System.out.println("-----------------------------------------");
            System.out.println(process.getOutput().toString());
            System.out.println("-----------------------------------------");
            System.out.println("\t\tEND SPAWNED PROCESS LOG");
            System.out.println("-----------------------------------------");
        }
    }

    protected static void touchFile(File file) throws IOException {
        if (!file.exists()) {
            new FileOutputStream(file).close();
        }
        if (!file.setLastModified(System.currentTimeMillis())) {
            throw new IOException("Could not touch the file.");
        }
    }

    protected static boolean waitForMarkerFiles(File basedir, String prefix, int num, long timeout) {
        long now = System.currentTimeMillis();
        long deadline = now + timeout;
        while (now < deadline) {
            boolean allFound = true;
            for (int i = 0; i < num; ++i) {
                File nextToCheck = new File(basedir, prefix + i);
                if (nextToCheck.exists()) continue;
                allFound = false;
                break;
            }
            if (allFound) {
                return true;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            now = System.currentTimeMillis();
        }
        return false;
    }

    public static class TaskExecutorProcessEntryPoint {
        private static final Logger LOG = LoggerFactory.getLogger(TaskExecutorProcessEntryPoint.class);

        public static void main(String[] args) {
            try {
                ParameterTool parameterTool = ParameterTool.fromArgs((String[])args);
                Configuration cfg = parameterTool.getConfiguration();
                TaskManagerRunner.runTaskManager((Configuration)cfg, (ResourceID)ResourceID.generate());
            }
            catch (Throwable t) {
                LOG.error("Failed to start TaskManager process", t);
                System.exit(1);
            }
        }
    }
}

