/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.operators;

import java.util.List;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.ProjectOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.test.operators.util.CollectionDataSets;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SumMinMaxITCase
extends MultipleProgramsTestBase {
    public SumMinMaxITCase(MultipleProgramsTestBase.TestExecutionMode mode) {
        super(mode);
    }

    @Test
    public void testSumMaxAndProject() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
        ProjectOperator sumDs = ds.sum(0).andMax(1).project(new int[]{0, 1});
        List result = sumDs.collect();
        String expected = "231,6\n";
        SumMinMaxITCase.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testGroupedAggregate() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
        ProjectOperator aggregateDs = ds.groupBy(new int[]{1}).sum(0).project(new int[]{1, 0});
        List result = aggregateDs.collect();
        String expected = "1,1\n2,5\n3,15\n4,34\n5,65\n6,111\n";
        SumMinMaxITCase.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testNestedAggregate() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
        ProjectOperator aggregateDs = ds.groupBy(new int[]{1}).min(0).min(0).project(new int[]{0});
        List result = aggregateDs.collect();
        String expected = "1\n";
        SumMinMaxITCase.compareResultAsTuples((List)result, (String)expected);
    }
}

