/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.runtime;

import org.apache.flink.api.common.BatchShuffleMode;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.test.runtime.BatchShuffleITCaseBase;
import org.junit.jupiter.api.Test;

class BlockingShuffleITCase
extends BatchShuffleITCaseBase {
    BlockingShuffleITCase() {
    }

    @Test
    public void testBoundedBlockingShuffle() throws Exception {
        int numRecordsToSend = 1000000;
        Configuration configuration = this.getConfiguration();
        configuration.set(NettyShuffleEnvironmentOptions.NETWORK_SORT_SHUFFLE_MIN_PARALLELISM, (Object)Integer.MAX_VALUE);
        JobGraph jobGraph = this.createJobGraph(1000000, false, false, configuration, false);
        this.executeJob(jobGraph, configuration, 1000000);
    }

    @Test
    public void testBoundedBlockingShuffleWithoutData() throws Exception {
        Configuration configuration = this.getConfiguration();
        configuration.set(NettyShuffleEnvironmentOptions.NETWORK_SORT_SHUFFLE_MIN_PARALLELISM, (Object)Integer.MAX_VALUE);
        JobGraph jobGraph = this.createJobGraph(0, false, false, configuration, false);
        this.executeJob(jobGraph, configuration, 0);
    }

    @Test
    public void testSortMergeBlockingShuffle() throws Exception {
        int numRecordsToSend = 1000000;
        Configuration configuration = this.getConfiguration();
        configuration.set(NettyShuffleEnvironmentOptions.NETWORK_SORT_SHUFFLE_MIN_BUFFERS, (Object)64);
        JobGraph jobGraph = this.createJobGraph(1000000, false, false, configuration, false);
        this.executeJob(jobGraph, configuration, 1000000);
    }

    @Test
    public void testSortMergeBlockingShuffleWithoutData() throws Exception {
        Configuration configuration = this.getConfiguration();
        configuration.set(NettyShuffleEnvironmentOptions.NETWORK_SORT_SHUFFLE_MIN_BUFFERS, (Object)64);
        JobGraph jobGraph = this.createJobGraph(0, false, false, configuration, false);
        this.executeJob(jobGraph, configuration, 0);
    }

    @Test
    public void testDeletePartitionFileOfBoundedBlockingShuffle() throws Exception {
        Configuration configuration = this.getConfiguration();
        configuration.set(NettyShuffleEnvironmentOptions.NETWORK_SORT_SHUFFLE_MIN_PARALLELISM, (Object)Integer.MAX_VALUE);
        JobGraph jobGraph = this.createJobGraph(0, false, true, configuration, false);
        this.executeJob(jobGraph, configuration, 0);
    }

    @Test
    public void testDeletePartitionFileOfSortMergeBlockingShuffle() throws Exception {
        Configuration configuration = this.getConfiguration();
        JobGraph jobGraph = this.createJobGraph(0, false, true, configuration, false);
        this.executeJob(jobGraph, configuration, 0);
    }

    @Override
    protected Configuration getConfiguration() {
        Configuration configuration = super.getConfiguration();
        configuration.set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)BatchShuffleMode.ALL_EXCHANGES_BLOCKING);
        return configuration;
    }
}

