/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recovery;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.functions.source.RichSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.test.util.AbstractTestBaseJUnit4;
import org.junit.Test;

public class FastFailuresITCase
extends AbstractTestBaseJUnit4 {
    static final AtomicInteger FAILURES_SO_FAR = new AtomicInteger();
    static final int NUM_FAILURES = 200;

    @Test
    public void testThis() throws Exception {
        int parallelism = 4;
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(4);
        env.enableCheckpointing(1000L);
        env.getConfig().setRestartStrategy(RestartStrategies.fixedDelayRestart((int)210, (long)0L));
        DataStreamSource input = env.addSource((SourceFunction)new RichSourceFunction<Tuple2<Integer, Integer>>(){

            public void open(OpenContext openContext) {
                if (FAILURES_SO_FAR.incrementAndGet() <= 200) {
                    throw new RuntimeException("fail");
                }
            }

            public void run(SourceFunction.SourceContext<Tuple2<Integer, Integer>> ctx) {
            }

            public void cancel() {
            }
        });
        input.keyBy(new int[]{0}).map((MapFunction)new MapFunction<Tuple2<Integer, Integer>, Integer>(){

            public Integer map(Tuple2<Integer, Integer> value) {
                return (Integer)value.f0;
            }
        }).addSink((SinkFunction)new SinkFunction<Integer>(){

            public void invoke(Integer value) {
            }
        });
        env.execute();
    }
}

