/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.operators;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.flink.api.common.functions.MapPartitionFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.LocalCollectionOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.test.util.JavaProgramTestBaseJUnit4;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.util.Collector;

public class MapPartitionITCase
extends JavaProgramTestBaseJUnit4 {
    private static final String IN = "1 1\n2 2\n2 8\n4 4\n4 4\n6 6\n7 7\n8 8\n1 1\n2 2\n2 2\n4 4\n4 4\n6 3\n5 9\n8 8\n1 1\n2 2\n2 2\n3 0\n4 4\n5 9\n7 7\n8 8\n1 1\n9 1\n5 9\n4 4\n4 4\n6 6\n7 7\n8 8\n";
    private static final String RESULT = "1 11\n2 12\n4 14\n4 14\n1 11\n2 12\n2 12\n4 14\n4 14\n3 16\n1 11\n2 12\n2 12\n0 13\n4 14\n1 11\n4 14\n4 14\n";
    private List<Tuple2<String, String>> input = new ArrayList<Tuple2<String, String>>();
    private List<Tuple2<String, Integer>> expected = new ArrayList<Tuple2<String, Integer>>();
    private List<Tuple2<String, Integer>> result = new ArrayList<Tuple2<String, Integer>>();

    protected void preSubmit() throws Exception {
        String[] fields;
        for (String s : IN.split("\n")) {
            fields = s.split(" ");
            this.input.add((Tuple2<String, String>)new Tuple2((Object)fields[0], (Object)fields[1]));
        }
        for (String s : RESULT.split("\n")) {
            fields = s.split(" ");
            this.expected.add((Tuple2<String, Integer>)new Tuple2((Object)fields[0], (Object)Integer.parseInt(fields[1])));
        }
    }

    protected void postSubmit() {
        TestBaseUtils.compareResultCollections(this.expected, this.result, (Comparator)new TestBaseUtils.TupleComparator());
    }

    protected void testProgram() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource data = env.fromCollection(this.input);
        data.mapPartition((MapPartitionFunction)new TestMapPartition()).output((OutputFormat)new LocalCollectionOutputFormat(this.result));
        env.execute();
    }

    private static class TestMapPartition
    implements MapPartitionFunction<Tuple2<String, String>, Tuple2<String, Integer>> {
        private TestMapPartition() {
        }

        public void mapPartition(Iterable<Tuple2<String, String>> values, Collector<Tuple2<String, Integer>> out) {
            for (Tuple2<String, String> value : values) {
                int valueInt;
                String keyString = (String)value.f0;
                String valueString = (String)value.f1;
                int keyInt = Integer.parseInt(keyString);
                if (keyInt + (valueInt = Integer.parseInt(valueString)) >= 10) continue;
                out.collect((Object)new Tuple2((Object)valueString, (Object)(keyInt + 10)));
            }
        }
    }
}

