/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.operators;

import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.test.util.JavaProgramTestBaseJUnit4;
import org.apache.flink.types.NullValue;
import org.apache.flink.util.Collector;
import org.junit.Assert;

public class CoGroupGroupSortITCase
extends JavaProgramTestBaseJUnit4 {
    protected void testProgram() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)0L, (Object)5L), new Tuple2((Object)0L, (Object)4L), new Tuple2((Object)0L, (Object)3L), new Tuple2((Object)0L, (Object)2L), new Tuple2((Object)0L, (Object)1L), new Tuple2((Object)1L, (Object)10L), new Tuple2((Object)1L, (Object)8L), new Tuple2((Object)1L, (Object)9L), new Tuple2((Object)1L, (Object)7L)});
        DataSource input2 = env.fromElements((Object[])new TestPojo[]{new TestPojo(0L, 10L, 3L), new TestPojo(0L, 8L, 3L), new TestPojo(0L, 10L, 1L), new TestPojo(0L, 9L, 0L), new TestPojo(0L, 8L, 2L), new TestPojo(0L, 8L, 4L), new TestPojo(1L, 10L, 3L), new TestPojo(1L, 8L, 3L), new TestPojo(1L, 10L, 1L), new TestPojo(1L, 9L, 0L), new TestPojo(1L, 8L, 2L), new TestPojo(1L, 8L, 4L)});
        input1.coGroup((DataSet)input2).where(new int[]{1}).equalTo(new String[]{"b"}).sortFirstGroup(0, Order.DESCENDING).sortSecondGroup("c", Order.ASCENDING).sortSecondGroup("a", Order.DESCENDING).with((CoGroupFunction)new ValidatingCoGroup()).output((OutputFormat)new DiscardingOutputFormat());
        env.execute();
    }

    public static class TestPojo
    implements Cloneable {
        public long a;
        public long b;
        public long c;

        public TestPojo() {
        }

        public TestPojo(long a, long b, long c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }
    }

    private static class ValidatingCoGroup
    implements CoGroupFunction<Tuple2<Long, Long>, TestPojo, NullValue> {
        private ValidatingCoGroup() {
        }

        public void coGroup(Iterable<Tuple2<Long, Long>> first, Iterable<TestPojo> second, Collector<NullValue> out) throws Exception {
            long lastValue = Long.MAX_VALUE;
            for (Tuple2<Long, Long> t : first) {
                long current = (Long)t.f1;
                Assert.assertTrue((current <= lastValue ? 1 : 0) != 0);
                lastValue = current;
            }
            TestPojo lastValue2 = new TestPojo(Long.MAX_VALUE, 0L, Long.MIN_VALUE);
            for (TestPojo current : second) {
                Assert.assertTrue((current.c >= lastValue2.c ? 1 : 0) != 0);
                Assert.assertTrue((current.c != lastValue2.c || current.a <= lastValue2.a ? 1 : 0) != 0);
                lastValue2 = current;
            }
        }
    }
}

