/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.io;

import java.io.File;
import java.util.List;
import java.util.Locale;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.test.util.MultipleProgramsTestBaseJUnit4;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.BooleanValue;
import org.apache.flink.types.ByteValue;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.FloatValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.ShortValue;
import org.apache.flink.types.StringValue;
import org.apache.flink.util.FileUtils;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CsvReaderITCase
extends MultipleProgramsTestBaseJUnit4 {
    private String expected;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    public CsvReaderITCase(MultipleProgramsTestBaseJUnit4.TestExecutionMode mode) {
        super(mode);
    }

    private String createInputData(String data) throws Exception {
        File file = this.tempFolder.newFile("input");
        FileUtils.writeFileUtf8((File)file, (String)data);
        return file.toURI().toString();
    }

    @Test
    public void testPOJOType() throws Exception {
        String inputData = "ABC,2.20,3\nDEF,5.1,5\nDEF,3.30,1\nGHI,3.30,10";
        String dataPath = this.createInputData("ABC,2.20,3\nDEF,5.1,5\nDEF,3.30,1\nGHI,3.30,10");
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource data = env.readCsvFile(dataPath).pojoType(POJOItem.class, new String[]{"f1", "f3", "f2"});
        List result = data.collect();
        this.expected = "ABC,3,2.20\nDEF,5,5.10\nDEF,1,3.30\nGHI,10,3.30";
        TestBaseUtils.compareResultAsText((List)result, (String)this.expected);
    }

    @Test
    public void testPOJOTypeWithFieldsOrder() throws Exception {
        String inputData = "2.20,ABC,3\n5.1,DEF,5\n3.30,DEF,1\n3.30,GHI,10";
        String dataPath = this.createInputData("2.20,ABC,3\n5.1,DEF,5\n3.30,DEF,1\n3.30,GHI,10");
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource data = env.readCsvFile(dataPath).pojoType(POJOItem.class, new String[]{"f3", "f1", "f2"});
        List result = data.collect();
        this.expected = "ABC,3,2.20\nDEF,5,5.10\nDEF,1,3.30\nGHI,10,3.30";
        TestBaseUtils.compareResultAsText((List)result, (String)this.expected);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPOJOTypeWithoutFieldsOrder() throws Exception {
        String inputData = "";
        String dataPath = this.createInputData("");
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.readCsvFile(dataPath).pojoType(POJOItem.class, new String[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPOJOTypeWitNullFieldsOrder() throws Exception {
        String inputData = "";
        String dataPath = this.createInputData("");
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.readCsvFile(dataPath).pojoType(POJOItem.class, null);
    }

    @Test
    public void testPOJOTypeWithFieldsOrderAndFieldsSelection() throws Exception {
        String inputData = "3,2.20,ABC\n5,5.1,DEF\n1,3.30,DEF\n10,3.30,GHI";
        String dataPath = this.createInputData("3,2.20,ABC\n5,5.1,DEF\n1,3.30,DEF\n10,3.30,GHI");
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource data = env.readCsvFile(dataPath).includeFields(new boolean[]{true, false, true}).pojoType(POJOItem.class, new String[]{"f2", "f1"});
        List result = data.collect();
        this.expected = "ABC,3,0.00\nDEF,5,0.00\nDEF,1,0.00\nGHI,10,0.00";
        TestBaseUtils.compareResultAsText((List)result, (String)this.expected);
    }

    @Test
    public void testValueTypes() throws Exception {
        String inputData = "ABC,true,1,2,3,4,5.0,6.0\nBCD,false,1,2,3,4,5.0,6.0";
        String dataPath = this.createInputData("ABC,true,1,2,3,4,5.0,6.0\nBCD,false,1,2,3,4,5.0,6.0");
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource data = env.readCsvFile(dataPath).types(StringValue.class, BooleanValue.class, ByteValue.class, ShortValue.class, IntValue.class, LongValue.class, FloatValue.class, DoubleValue.class);
        List result = data.collect();
        this.expected = "ABC,true,1,2,3,4,5.0,6.0\nBCD,false,1,2,3,4,5.0,6.0";
        TestBaseUtils.compareResultAsTuples((List)result, (String)this.expected);
    }

    public static class POJOItem {
        public String f1;
        private int f2;
        public double f3;

        public int getF2() {
            return this.f2;
        }

        public void setF2(int f2) {
            this.f2 = f2;
        }

        public String toString() {
            return String.format(Locale.US, "%s,%d,%.02f", this.f1, this.f2, this.f3);
        }
    }
}

