/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.example.java;

import java.io.BufferedReader;
import org.apache.flink.examples.java.graph.ConnectedComponents;
import org.apache.flink.test.testdata.ConnectedComponentsData;
import org.apache.flink.test.util.JavaProgramTestBaseJUnit4;
import org.apache.flink.test.util.TestBaseUtils;

public class ConnectedComponentsITCase
extends JavaProgramTestBaseJUnit4 {
    private static final long SEED = 3287269182979823L;
    private static final int NUM_VERTICES = 1000;
    private static final int NUM_EDGES = 10000;
    private String verticesPath;
    private String edgesPath;
    private String resultPath;

    protected void preSubmit() throws Exception {
        this.verticesPath = this.createTempFile("vertices.txt", ConnectedComponentsData.getEnumeratingVertices((int)1000));
        this.edgesPath = this.createTempFile("edges.txt", ConnectedComponentsData.getRandomOddEvenEdges((int)10000, (int)1000, (long)3287269182979823L));
        this.resultPath = this.getTempFilePath("results");
    }

    protected void testProgram() throws Exception {
        ConnectedComponents.main((String[])new String[]{"--vertices", this.verticesPath, "--edges", this.edgesPath, "--output", this.resultPath, "--iterations", "100"});
    }

    protected void postSubmit() throws Exception {
        for (BufferedReader reader : TestBaseUtils.getResultReader((String)this.resultPath)) {
            ConnectedComponentsData.checkOddEvenResult((BufferedReader)reader);
        }
    }
}

