/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.checkpointing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.StateRecoveryOptions;
import org.apache.flink.test.checkpointing.EventTimeWindowCheckpointingITCase;
import org.apache.flink.util.TestLogger;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LocalRecoveryITCase
extends TestLogger {
    @Rule
    public TestName testName = new TestName();
    @Parameterized.Parameter
    public EventTimeWindowCheckpointingITCase.StateBackendEnum backendEnum;
    @Parameterized.Parameter(value=1)
    public boolean localRecoveryEnabled;
    @Parameterized.Parameter(value=2)
    public boolean localBackupEnabled;
    private static final List<EventTimeWindowCheckpointingITCase.StateBackendEnum> STATE_BACKEND_ENUMS = Arrays.asList(EventTimeWindowCheckpointingITCase.StateBackendEnum.ROCKSDB_FULL, EventTimeWindowCheckpointingITCase.StateBackendEnum.ROCKSDB_INCREMENTAL_ZK, EventTimeWindowCheckpointingITCase.StateBackendEnum.FILE);
    private static final List<Tuple2<Boolean, Boolean>> LOCAL_BACKUP_AND_RECOVERY_CONFIGS = Arrays.asList(Tuple2.of((Object)true, (Object)true), Tuple2.of((Object)true, (Object)false), Tuple2.of((Object)false, (Object)true));

    @Parameterized.Parameters(name="stateBackendType = {0}, localBackupEnabled = {1}, localRecoveryEnabled = {2}")
    public static Collection<Object[]> parameter() {
        ArrayList<Object[]> parameterList = new ArrayList<Object[]>();
        for (EventTimeWindowCheckpointingITCase.StateBackendEnum stateBackend : STATE_BACKEND_ENUMS) {
            for (Tuple2<Boolean, Boolean> backupAndRecoveryConfig : LOCAL_BACKUP_AND_RECOVERY_CONFIGS) {
                parameterList.add(new Object[]{stateBackend, backupAndRecoveryConfig.f0, backupAndRecoveryConfig.f1});
            }
        }
        return parameterList;
    }

    @Test
    public final void executeTest() throws Exception {
        EventTimeWindowCheckpointingITCase.tempFolder.create();
        EventTimeWindowCheckpointingITCaseInstance windowChkITCase = new EventTimeWindowCheckpointingITCaseInstance(this.backendEnum, this.localBackupEnabled, this.localRecoveryEnabled);
        this.executeTest(windowChkITCase);
    }

    private void executeTest(EventTimeWindowCheckpointingITCase delegate) throws Exception {
        delegate.name = this.testName;
        delegate.stateBackendEnum = this.backendEnum;
        try {
            delegate.setupTestCluster();
            try {
                delegate.testTumblingTimeWindow();
                delegate.stopTestCluster();
            }
            catch (Exception e) {
                delegate.stopTestCluster();
                throw new RuntimeException(e);
            }
            delegate.setupTestCluster();
            try {
                delegate.testSlidingTimeWindow();
                delegate.stopTestCluster();
            }
            catch (Exception e) {
                delegate.stopTestCluster();
                throw new RuntimeException(e);
            }
        }
        finally {
            EventTimeWindowCheckpointingITCase.tempFolder.delete();
        }
    }

    @Ignore(value="Prevents this class from being considered a test class by JUnit.")
    private static class EventTimeWindowCheckpointingITCaseInstance
    extends EventTimeWindowCheckpointingITCase {
        private final EventTimeWindowCheckpointingITCase.StateBackendEnum backendEnum;
        private final boolean localBackupEnable;
        private final boolean localRecoveryEnabled;

        public EventTimeWindowCheckpointingITCaseInstance(EventTimeWindowCheckpointingITCase.StateBackendEnum backendEnum, boolean localBackupEnable, boolean localRecoveryEnabled) {
            super(backendEnum, 2);
            this.backendEnum = backendEnum;
            this.localBackupEnable = localBackupEnable;
            this.localRecoveryEnabled = localRecoveryEnabled;
        }

        @Override
        protected EventTimeWindowCheckpointingITCase.StateBackendEnum getStateBackend() {
            return this.backendEnum;
        }

        @Override
        protected Configuration createClusterConfig() throws IOException {
            Configuration config = super.createClusterConfig();
            config.set(StateRecoveryOptions.LOCAL_RECOVERY, (Object)this.localRecoveryEnabled);
            config.set(CheckpointingOptions.LOCAL_BACKUP_ENABLED, (Object)this.localBackupEnable);
            return config;
        }
    }
}

