/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.actions;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.CrossOperator;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.test.util.MultipleProgramsTestBaseJUnit4;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CountCollectITCase
extends MultipleProgramsTestBaseJUnit4 {
    public CountCollectITCase(MultipleProgramsTestBaseJUnit4.TestExecutionMode mode) {
        super(mode);
    }

    @Test
    public void testSimple() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        Object[] input = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        DataSource data = env.fromElements(input);
        long numEntries = data.count();
        Assert.assertEquals((long)10L, (long)numEntries);
        ArrayList list = (ArrayList)data.collect();
        Assert.assertArrayEquals((Object[])input, (Object[])list.toArray());
    }

    @Test
    public void testAdvanced() throws Exception {
        int i;
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.getConfig().disableObjectReuse();
        DataSource data = env.fromElements((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        DataSource data2 = env.fromElements((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        CrossOperator.DefaultCross data3 = data.cross((DataSet)data2);
        long numEntries = data3.count();
        Assert.assertEquals((long)100L, (long)numEntries);
        ArrayList list = (ArrayList)data3.collect();
        HashMap<Tuple2, Boolean> expected = new HashMap<Tuple2, Boolean>();
        for (i = 1; i <= 10; ++i) {
            for (int j = 1; j <= 10; ++j) {
                expected.put(new Tuple2((Object)i, (Object)j), true);
            }
        }
        for (i = 0; i < 100; ++i) {
            Tuple2 element = (Tuple2)list.get(i);
            Assert.assertEquals(expected.get(element), (Object)true);
            expected.remove(element);
        }
    }
}

