/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.operators;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichReduceFunction;
import org.apache.flink.api.common.operators.base.ReduceOperatorBase;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.operators.ReduceITCase$;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.api.scala.util.CollectionDataSets;
import org.apache.flink.api.scala.util.CollectionDataSets$;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.test.util.MultipleProgramsTestBaseJUnit4;
import org.apache.flink.test.util.TestBaseUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001B\u0001\u0003\u0001=\u0011ABU3ek\u000e,\u0017\nV\"bg\u0016T!a\u0001\u0003\u0002\u0013=\u0004XM]1u_J\u001c(BA\u0003\u0007\u0003\u0015\u00198-\u00197b\u0015\t9\u0001\"A\u0002ba&T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012-5\t!C\u0003\u0002\u0014)\u0005!Q\u000f^5m\u0015\t)\u0002\"\u0001\u0003uKN$\u0018BA\f\u0013\u0005yiU\u000f\u001c;ja2,\u0007K]8he\u0006l7\u000fV3ti\n\u000b7/\u001a&V]&$H\u0007\u0003\u0005\u001a\u0001\t\u0005\t\u0015!\u0003\u001b\u0003\u0011iw\u000eZ3\u0011\u0005mqbBA\t\u001d\u0013\ti\"#\u0001\u0010Nk2$\u0018\u000e\u001d7f!J|wM]1ngR+7\u000f\u001e\"bg\u0016TUK\\5ui%\u0011q\u0004\t\u0002\u0012)\u0016\u001cH/\u0012=fGV$\u0018n\u001c8N_\u0012,'BA\u000f\u0013\u0011\u0015\u0011\u0003\u0001\"\u0001$\u0003\u0019a\u0014N\\5u}Q\u0011AE\n\t\u0003K\u0001i\u0011A\u0001\u0005\u00063\u0005\u0002\rA\u0007\u0005\bQ\u0001\u0001\r\u0011\"\u0003*\u0003)\u0011Xm];miB\u000bG\u000f[\u000b\u0002UA\u00111f\r\b\u0003YE\u0002\"!\f\u0019\u000e\u00039R!a\f\b\u0002\rq\u0012xn\u001c;?\u0015\u0005)\u0011B\u0001\u001a1\u0003\u0019\u0001&/\u001a3fM&\u0011A'\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I\u0002\u0004bB\u001c\u0001\u0001\u0004%I\u0001O\u0001\u000fe\u0016\u001cX\u000f\u001c;QCRDw\fJ3r)\tIT\b\u0005\u0002;w5\t\u0001'\u0003\u0002=a\t!QK\\5u\u0011\u001dqd'!AA\u0002)\n1\u0001\u001f\u00132\u0011\u0019\u0001\u0005\u0001)Q\u0005U\u0005Y!/Z:vYR\u0004\u0016\r\u001e5!\u0011\u001d\u0011\u0005\u00011A\u0005\n%\n\u0001\"\u001a=qK\u000e$X\r\u001a\u0005\b\t\u0002\u0001\r\u0011\"\u0003F\u00031)\u0007\u0010]3di\u0016$w\fJ3r)\tId\tC\u0004?\u0007\u0006\u0005\t\u0019\u0001\u0016\t\r!\u0003\u0001\u0015)\u0003+\u0003%)\u0007\u0010]3di\u0016$\u0007\u0005C\u0004K\u0001\t\u0007I\u0011B&\u0002\u0017}#X-\u001c9G_2$WM]\u000b\u0002\u0019B\u0011QJU\u0007\u0002\u001d*\u0011q\nU\u0001\u0006eVdWm\u001d\u0006\u0003#2\tQA[;oSRL!a\u0015(\u0003\u001fQ+W\u000e]8sCJLhi\u001c7eKJDa!\u0016\u0001!\u0002\u0013a\u0015\u0001D0uK6\u0004hi\u001c7eKJ\u0004\u0003\"B,\u0001\t\u0003Y\u0015A\u0003;f[B4u\u000e\u001c3fe\"\u0012a+\u0017\t\u00035nk\u0011\u0001U\u0005\u00039B\u0013AAU;mK\")a\f\u0001C\u0001?\u00061!-\u001a4pe\u0016$\u0012!\u000f\u0015\u0003;\u0006\u0004\"A\u00172\n\u0005\r\u0004&A\u0002\"fM>\u0014X\rC\u0003f\u0001\u0011\u0005q,A\u0003bMR,'\u000f\u000b\u0002eOB\u0011!\f[\u0005\u0003SB\u0013Q!\u00114uKJDQa\u001b\u0001\u0005\u0002}\u000ba\u0005^3tiJ+G-^2f\u001f:$V\u000f\u001d7fg^KG\u000f[&fs\u001aKW\r\u001c3TK2,7\r^8sQ\tQW\u000e\u0005\u0002[]&\u0011q\u000e\u0015\u0002\u0005)\u0016\u001cH\u000fC\u0003r\u0001\u0011\u0005q,A\u0018uKN$(+\u001a3vG\u0016|e\u000eV;qY\u0016\u001cx+\u001b;i\u001bVdG/\u001b9mK.+\u0017PR5fY\u0012\u001cV\r\\3di>\u00148\u000f\u000b\u0002q[\")A\u000f\u0001C\u0001?\u0006\u0011C/Z:u%\u0016$WoY3P]R+\b\u000f\\3t/&$\bnS3z\u000bb$(/Y2u_JD#a]7\t\u000b]\u0004A\u0011A0\u0002MQ,7\u000f\u001e*fIV\u001cWm\u00148DkN$x.\u001c+za\u0016<\u0016\u000e\u001e5LKf,\u0005\u0010\u001e:bGR|'\u000f\u000b\u0002w[\")!\u0010\u0001C\u0001?\u0006)B/Z:u\u00032d'+\u001a3vG\u00164uN\u001d+va2,\u0007FA=n\u0011\u0015i\b\u0001\"\u0001`\u0003m!Xm\u001d;BY2\u0014V\rZ;dK\u001a{'oQ;ti>lG+\u001f9fg\"\u0012A0\u001c\u0005\u0007\u0003\u0003\u0001A\u0011A0\u00025Q,7\u000f\u001e*fIV\u001cWmV5uQ\n\u0013x.\u00193dCN$8+\u001a;)\u0005}l\u0007BBA\u0004\u0001\u0011\u0005q,\u0001\u0019uKN$(+\u001a3vG\u0016<\u0016\u000e\u001e5V\t\u001a#\u0006.\u0019;SKR,(O\\:UQ\u0016\u001cVmY8oI&s\u0007/\u001e;PE*,7\r\u001e\u0015\u0004\u0003\u000bi\u0007BBA\u0007\u0001\u0011\u0005q,\u0001\u0015uKN$(+\u001a3vG\u0016<\u0016\u000e\u001e5B)V\u0004H.\u001a*fiV\u0014h.\u001b8h\u0017\u0016L8+\u001a7fGR|'\u000fK\u0002\u0002\f5Da!a\u0005\u0001\t\u0003y\u0016\u0001\n;fgR\u0014V\rZ;dK>swI]8va\u0016$Gi\u0015\"z\u000bb\u0004(/Z:tS>t7*Z=)\u0007\u0005EQ\u000e\u0003\u0004\u0002\u001a\u0001!\taX\u00011i\u0016\u001cHOU3ek\u000e,wJ\\$s_V\u0004X\r\u001a#T\u0005f,\u0005\u0010\u001d:fgNLwN\\&fs^KG\u000f\u001b%bg\"D\u0015N\u001c;)\u0007\u0005]Q\u000eK\u0004\u0001\u0003?\tY#!\f\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\nQ\u0003\u0019\u0011XO\u001c8fe&!\u0011\u0011FA\u0012\u0005\u001d\u0011VO\\,ji\"\fQA^1mk\u0016\u001c#!a\f\u0011\t\u0005E\u0012qG\u0007\u0003\u0003gQ1!!\u000eQ\u0003\u001d\u0011XO\u001c8feNLA!!\u000f\u00024\ti\u0001+\u0019:b[\u0016$XM]5{K\u0012\u0004")
public class ReduceITCase
extends MultipleProgramsTestBaseJUnit4 {
    private String resultPath = null;
    private String expected = null;
    private final TemporaryFolder _tempFolder = new TemporaryFolder();

    private String resultPath() {
        return this.resultPath;
    }

    private void resultPath_$eq(String x$1) {
        this.resultPath = x$1;
    }

    private String expected() {
        return this.expected;
    }

    private void expected_$eq(String x$1) {
        this.expected = x$1;
    }

    private TemporaryFolder _tempFolder() {
        return this._tempFolder;
    }

    @Rule
    public TemporaryFolder tempFolder() {
        return this._tempFolder();
    }

    @Before
    public void before() {
        this.resultPath_$eq(this.tempFolder().newFile().toURI().toString());
    }

    @After
    public void after() {
        TestBaseUtils.compareResultsByLinesInMemory((String)this.expected(), (String)this.resultPath());
    }

    @Test
    public void testReduceOnTuplesWithKeyFieldSelector() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet reduceDs = ds.groupBy((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})).reduce((Function2 & Serializable & scala.Serializable)(in1, in2) -> new Tuple3((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)in1._1()) + BoxesRunTime.unboxToInt((Object)in2._1()))), in1._2(), (Object)"B-)"));
        String x$3 = this.resultPath();
        FileSystem.WriteMode x$4 = FileSystem.WriteMode.OVERWRITE;
        String x$5 = reduceDs.writeAsCsv$default$2();
        String x$6 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$3, x$5, x$6, x$4);
        env.execute();
        this.expected_$eq("1,1,Hi\n5,2,B-)\n15,3,B-)\n34,4,B-)\n65,5,B-)\n111,6,B-)\n");
    }

    @Test
    public void testReduceOnTuplesWithMultipleKeyFieldSelectors() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple5<Object, Object, Object, String, Object>> ds = CollectionDataSets$.MODULE$.get5TupleDataSet(env);
        DataSet reduceDs = ds.groupBy((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 0})).reduce((Function2 & Serializable & scala.Serializable)(in1, in2) -> new Tuple5(in1._1(), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)in1._2()) + BoxesRunTime.unboxToLong((Object)in2._2()))), (Object)BoxesRunTime.boxToInteger((int)0), (Object)"P-)", in1._5()));
        String x$7 = this.resultPath();
        FileSystem.WriteMode x$8 = FileSystem.WriteMode.OVERWRITE;
        String x$9 = reduceDs.writeAsCsv$default$2();
        String x$10 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$7, x$9, x$10, x$8);
        env.execute();
        this.expected_$eq("1,1,0,Hallo,1\n2,3,2,Hallo Welt wie,1\n2,2,1,Hallo Welt,2\n3,9,0,P-),2\n3,6,5,BCD,3\n4,17,0,P-),1\n4,17,0,P-),2\n5,11,10,GHI,1\n5,29,0,P-),2\n5,25,0,P-),3\n");
    }

    @Test
    public void testReduceOnTuplesWithKeyExtractor() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet reduceDs = ds.groupBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)ReduceITCase.$anonfun$testReduceOnTuplesWithKeyExtractor$1(x$1)), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE)).reduce((Function2 & Serializable & scala.Serializable)(in1, in2) -> new Tuple3((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)in1._1()) + BoxesRunTime.unboxToInt((Object)in2._1()))), in1._2(), (Object)"B-)"));
        String x$11 = this.resultPath();
        FileSystem.WriteMode x$12 = FileSystem.WriteMode.OVERWRITE;
        String x$13 = reduceDs.writeAsCsv$default$2();
        String x$14 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$11, x$13, x$14, x$12);
        env.execute();
        this.expected_$eq("1,1,Hi\n5,2,B-)\n15,3,B-)\n34,4,B-)\n65,5,B-)\n111,6,B-)\n");
    }

    @Test
    public void testReduceOnCustomTypeWithKeyExtractor() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<CollectionDataSets.CustomType> ds = CollectionDataSets$.MODULE$.getCustomTypeDataSet(env);
        DataSet reduceDs = ds.groupBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.myInt()), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE)).reduce((Function2 & Serializable & scala.Serializable)(in1, in2) -> {
            in1.myLong_$eq(in1.myLong() + in2.myLong());
            in1.myString_$eq("Hello!");
            return in1;
        });
        reduceDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("1,0,Hi\n2,3,Hello!\n3,12,Hello!\n4,30,Hello!\n5,60,Hello!\n6,105,Hello!\n");
    }

    @Test
    public void testAllReduceForTuple() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet reduceDs = ds.reduce((Function2 & Serializable & scala.Serializable)(in1, in2) -> new Tuple3((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)in1._1()) + BoxesRunTime.unboxToInt((Object)in2._1()))), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)in1._2()) + BoxesRunTime.unboxToLong((Object)in2._2()))), (Object)"Hello World"));
        String x$15 = this.resultPath();
        FileSystem.WriteMode x$16 = FileSystem.WriteMode.OVERWRITE;
        String x$17 = reduceDs.writeAsCsv$default$2();
        String x$18 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$15, x$17, x$18, x$16);
        env.execute();
        this.expected_$eq("231,91,Hello World\n");
    }

    @Test
    public void testAllReduceForCustomTypes() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<CollectionDataSets.CustomType> ds = CollectionDataSets$.MODULE$.getCustomTypeDataSet(env);
        DataSet reduceDs = ds.reduce((Function2 & Serializable & scala.Serializable)(in1, in2) -> {
            in1.myInt_$eq(in1.myInt() + in2.myInt());
            in1.myLong_$eq(in1.myLong() + in2.myLong());
            in1.myString_$eq("Hello!");
            return in1;
        });
        reduceDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("91,210,Hello!");
    }

    @Test
    public void testReduceWithBroadcastSet() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Object> intDs = CollectionDataSets$.MODULE$.getIntDataSet(env);
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet reduceDs = ds.groupBy((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})).reduce((ReduceFunction)new RichReduceFunction<Tuple3<Object, Object, String>>(null){
            private String f2Replace;

            private String f2Replace() {
                return this.f2Replace;
            }

            private void f2Replace_$eq(String x$1) {
                this.f2Replace = x$1;
            }

            public void open(OpenContext openContext) {
                Buffer ints = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.getRuntimeContext().getBroadcastVariable("ints")).asScala();
                this.f2Replace_$eq(new StringBuilder(0).append(BoxesRunTime.unboxToInt((Object)ints.sum((Numeric)Numeric.IntIsIntegral$.MODULE$))).toString());
            }

            public Tuple3<Object, Object, String> reduce(Tuple3<Object, Object, String> in1, Tuple3<Object, Object, String> in2) {
                return new Tuple3((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)in1._1()) + BoxesRunTime.unboxToInt((Object)in2._1()))), in1._2(), (Object)this.f2Replace());
            }
            {
                this.f2Replace = "";
            }
        }).withBroadcastSet(intDs, "ints");
        String x$19 = this.resultPath();
        FileSystem.WriteMode x$20 = FileSystem.WriteMode.OVERWRITE;
        String x$21 = reduceDs.writeAsCsv$default$2();
        String x$22 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$19, x$21, x$22, x$20);
        env.execute();
        this.expected_$eq("1,1,Hi\n5,2,55\n15,3,55\n34,4,55\n65,5,55\n111,6,55\n");
    }

    @Test
    public void testReduceWithUDFThatReturnsTheSecondInputObject() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env).map((Function1 & Serializable & scala.Serializable)t -> new CollectionDataSets.MutableTuple3<Object, Object, Object>(t._1(), t._2(), t._3()), (TypeInformation)new CaseClassTypeInfo<CollectionDataSets.MutableTuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>>(this, fieldSerializers){

                    public CollectionDataSets.MutableTuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new CollectionDataSets.MutableTuple3<Object, Object, String>(BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (String)fields[2]);
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.api.scala.operators.ReduceITCase$$anon$5 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(CollectionDataSets.MutableTuple3.class));
        DataSet reduceDs = ds.groupBy((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})).reduce((ReduceFunction)new RichReduceFunction<CollectionDataSets.MutableTuple3<Object, Object, String>>(null){

            public CollectionDataSets.MutableTuple3<Object, Object, String> reduce(CollectionDataSets.MutableTuple3<Object, Object, String> in1, CollectionDataSets.MutableTuple3<Object, Object, String> in2) {
                in2._1_$eq(BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)in1._1()) + BoxesRunTime.unboxToInt((Object)in2._1()))));
                in2._3_$eq("Hi again!");
                return in2;
            }
        });
        String x$23 = this.resultPath();
        FileSystem.WriteMode x$24 = FileSystem.WriteMode.OVERWRITE;
        String x$25 = reduceDs.writeAsCsv$default$2();
        String x$26 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$23, x$25, x$26, x$24);
        env.execute();
        this.expected_$eq("1,1,Hi\n5,2,Hi again!\n15,3,Hi again!\n34,4,Hi again!\n65,5,Hi again!\n111,6,Hi again!\n");
    }

    @Test
    public void testReduceWithATupleReturningKeySelector() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple5<Object, Object, Object, String, Object>> ds = CollectionDataSets$.MODULE$.get5TupleDataSet(env);
        DataSet reduceDs = ds.groupBy((Function1 & Serializable & scala.Serializable)t -> new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)t._1()), BoxesRunTime.unboxToLong((Object)t._5())), (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.api.scala.operators.ReduceITCase$$anon$6 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).reduce((Function2 & Serializable & scala.Serializable)(in1, in2) -> new Tuple5(in1._1(), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)in1._2()) + BoxesRunTime.unboxToLong((Object)in2._2()))), (Object)BoxesRunTime.boxToInteger((int)0), (Object)"P-)", in1._5()));
        String x$27 = this.resultPath();
        FileSystem.WriteMode x$28 = FileSystem.WriteMode.OVERWRITE;
        String x$29 = reduceDs.writeAsCsv$default$2();
        String x$30 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$27, x$29, x$30, x$28);
        env.execute();
        this.expected_$eq("1,1,0,Hallo,1\n2,3,2,Hallo Welt wie,1\n2,2,1,Hallo Welt,2\n3,9,0,P-),2\n3,6,5,BCD,3\n4,17,0,P-),1\n4,17,0,P-),2\n5,11,10,GHI,1\n5,29,0,P-),2\n5,25,0,P-),3\n");
    }

    @Test
    public void testReduceOnGroupedDSByExpressionKey() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple5<Object, Object, Object, String, Object>> ds = CollectionDataSets$.MODULE$.get5TupleDataSet(env);
        DataSet reduceDs = ds.groupBy("_5", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_1"})).reduce((Function2 & Serializable & scala.Serializable)(in1, in2) -> new Tuple5(in1._1(), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)in1._2()) + BoxesRunTime.unboxToLong((Object)in2._2()))), (Object)BoxesRunTime.boxToInteger((int)0), (Object)"P-)", in1._5()));
        String x$31 = this.resultPath();
        FileSystem.WriteMode x$32 = FileSystem.WriteMode.OVERWRITE;
        String x$33 = reduceDs.writeAsCsv$default$2();
        String x$34 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$31, x$33, x$34, x$32);
        env.execute();
        this.expected_$eq("1,1,0,Hallo,1\n2,3,2,Hallo Welt wie,1\n2,2,1,Hallo Welt,2\n3,9,0,P-),2\n3,6,5,BCD,3\n4,17,0,P-),1\n4,17,0,P-),2\n5,11,10,GHI,1\n5,29,0,P-),2\n5,25,0,P-),3\n");
    }

    @Test
    public void testReduceOnGroupedDSByExpressionKeyWithHashHint() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple5<Object, Object, Object, String, Object>> ds = CollectionDataSets$.MODULE$.get5TupleDataSet(env);
        DataSet reduceDs = ds.groupBy("_5", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_1"})).reduce((Function2 & Serializable & scala.Serializable)(in1, in2) -> new Tuple5(in1._1(), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)in1._2()) + BoxesRunTime.unboxToLong((Object)in2._2()))), (Object)BoxesRunTime.boxToInteger((int)0), (Object)"P-)", in1._5()), ReduceOperatorBase.CombineHint.HASH);
        String x$35 = this.resultPath();
        FileSystem.WriteMode x$36 = FileSystem.WriteMode.OVERWRITE;
        String x$37 = reduceDs.writeAsCsv$default$2();
        String x$38 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$35, x$37, x$38, x$36);
        env.execute();
        this.expected_$eq("1,1,0,Hallo,1\n2,3,2,Hallo Welt wie,1\n2,2,1,Hallo Welt,2\n3,9,0,P-),2\n3,6,5,BCD,3\n4,17,0,P-),1\n4,17,0,P-),2\n5,11,10,GHI,1\n5,29,0,P-),2\n5,25,0,P-),3\n");
    }

    public static final /* synthetic */ long $anonfun$testReduceOnTuplesWithKeyExtractor$1(Tuple3 x$1) {
        return BoxesRunTime.unboxToLong((Object)x$1._2());
    }

    public ReduceITCase(MultipleProgramsTestBaseJUnit4.TestExecutionMode mode) {
        super(mode);
    }
}

