/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.operators;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichFilterFunction;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.util.CollectionDataSets;
import org.apache.flink.api.scala.util.CollectionDataSets$;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.test.util.MultipleProgramsTestBaseJUnit4;
import org.apache.flink.test.util.TestBaseUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001B\u0001\u0003\u0001=\u0011ABR5mi\u0016\u0014\u0018\nV\"bg\u0016T!a\u0001\u0003\u0002\u0013=\u0004XM]1u_J\u001c(BA\u0003\u0007\u0003\u0015\u00198-\u00197b\u0015\t9\u0001\"A\u0002ba&T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012-5\t!C\u0003\u0002\u0014)\u0005!Q\u000f^5m\u0015\t)\u0002\"\u0001\u0003uKN$\u0018BA\f\u0013\u0005yiU\u000f\u001c;ja2,\u0007K]8he\u0006l7\u000fV3ti\n\u000b7/\u001a&V]&$H\u0007\u0003\u0005\u001a\u0001\t\u0005\t\u0015!\u0003\u001b\u0003\u0011iw\u000eZ3\u0011\u0005mqbBA\t\u001d\u0013\ti\"#\u0001\u0010Nk2$\u0018\u000e\u001d7f!J|wM]1ngR+7\u000f\u001e\"bg\u0016TUK\\5ui%\u0011q\u0004\t\u0002\u0012)\u0016\u001cH/\u0012=fGV$\u0018n\u001c8N_\u0012,'BA\u000f\u0013\u0011\u0015\u0011\u0003\u0001\"\u0001$\u0003\u0019a\u0014N\\5u}Q\u0011AE\n\t\u0003K\u0001i\u0011A\u0001\u0005\u00063\u0005\u0002\rA\u0007\u0005\bQ\u0001\u0001\r\u0011\"\u0003*\u0003)\u0011Xm];miB\u000bG\u000f[\u000b\u0002UA\u00111f\r\b\u0003YE\u0002\"!\f\u0019\u000e\u00039R!a\f\b\u0002\rq\u0012xn\u001c;?\u0015\u0005)\u0011B\u0001\u001a1\u0003\u0019\u0001&/\u001a3fM&\u0011A'\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I\u0002\u0004bB\u001c\u0001\u0001\u0004%I\u0001O\u0001\u000fe\u0016\u001cX\u000f\u001c;QCRDw\fJ3r)\tIT\b\u0005\u0002;w5\t\u0001'\u0003\u0002=a\t!QK\\5u\u0011\u001dqd'!AA\u0002)\n1\u0001\u001f\u00132\u0011\u0019\u0001\u0005\u0001)Q\u0005U\u0005Y!/Z:vYR\u0004\u0016\r\u001e5!\u0011\u001d\u0011\u0005\u00011A\u0005\n%\n\u0001\"\u001a=qK\u000e$X\r\u001a\u0005\b\t\u0002\u0001\r\u0011\"\u0003F\u00031)\u0007\u0010]3di\u0016$w\fJ3r)\tId\tC\u0004?\u0007\u0006\u0005\t\u0019\u0001\u0016\t\r!\u0003\u0001\u0015)\u0003+\u0003%)\u0007\u0010]3di\u0016$\u0007\u0005C\u0004K\u0001\t\u0007I\u0011B&\u0002\u0017}#X-\u001c9G_2$WM]\u000b\u0002\u0019B\u0011QJU\u0007\u0002\u001d*\u0011q\nU\u0001\u0006eVdWm\u001d\u0006\u0003#2\tQA[;oSRL!a\u0015(\u0003\u001fQ+W\u000e]8sCJLhi\u001c7eKJDa!\u0016\u0001!\u0002\u0013a\u0015\u0001D0uK6\u0004hi\u001c7eKJ\u0004\u0003\"B,\u0001\t\u0003Y\u0015A\u0003;f[B4u\u000e\u001c3fe\"\u0012a+\u0017\t\u00035nk\u0011\u0001U\u0005\u00039B\u0013AAU;mK\")a\f\u0001C\u0001?\u00061!-\u001a4pe\u0016$\u0012!\u000f\u0015\u0003;\u0006\u0004\"A\u00172\n\u0005\r\u0004&A\u0002\"fM>\u0014X\rC\u0003f\u0001\u0011\u0005q,A\u0003bMR,'\u000f\u000b\u0002eOB\u0011!\f[\u0005\u0003SB\u0013Q!\u00114uKJDQa\u001b\u0001\u0005\u0002}\u000ba\u0003^3ti\u0006cGNU3kK\u000e$\u0018N\\4GS2$XM\u001d\u0015\u0003U6\u0004\"A\u00178\n\u0005=\u0004&\u0001\u0002+fgRDQ!\u001d\u0001\u0005\u0002}\u000bA\u0003^3ti\u0006cG\u000eU1tg&twMR5mi\u0016\u0014\bF\u00019n\u0011\u0015!\b\u0001\"\u0001`\u0003q!Xm\u001d;GS2$XM](o'R\u0014\u0018N\\4UkBdWMR5fY\u0012D#a]7\t\u000b]\u0004A\u0011A0\u0002;Q,7\u000f\u001e$jYR,'o\u00148J]R,w-\u001a:UkBdWMR5fY\u0012D#A^7\t\u000bi\u0004A\u0011A0\u0002'Q,7\u000f\u001e$jYR,'OQ1tS\u000e$\u0016\u0010]3)\u0005el\u0007\"B?\u0001\t\u0003y\u0016A\u0006;fgR4\u0015\u000e\u001c;fe>s7)^:u_6$\u0016\u0010]3)\u0005ql\u0007BBA\u0001\u0001\u0011\u0005q,\u0001\u0011uKN$(+[2i\r&dG/\u001a:P]N#(/\u001b8h)V\u0004H.\u001a$jK2$\u0007FA@nQ\u001d\u0001\u0011qAA\n\u0003+\u0001B!!\u0003\u0002\u00105\u0011\u00111\u0002\u0006\u0004\u0003\u001b\u0001\u0016A\u0002:v]:,'/\u0003\u0003\u0002\u0012\u0005-!a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u0003\u0003/\u0001B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;\u0001\u0016a\u0002:v]:,'o]\u0005\u0005\u0003C\tYBA\u0007QCJ\fW.\u001a;fe&TX\r\u001a")
public class FilterITCase
extends MultipleProgramsTestBaseJUnit4 {
    private String resultPath = null;
    private String expected = null;
    private final TemporaryFolder _tempFolder = new TemporaryFolder();

    private String resultPath() {
        return this.resultPath;
    }

    private void resultPath_$eq(String x$1) {
        this.resultPath = x$1;
    }

    private String expected() {
        return this.expected;
    }

    private void expected_$eq(String x$1) {
        this.expected = x$1;
    }

    private TemporaryFolder _tempFolder() {
        return this._tempFolder;
    }

    @Rule
    public TemporaryFolder tempFolder() {
        return this._tempFolder();
    }

    @Before
    public void before() {
        this.resultPath_$eq(this.tempFolder().newFile().toURI().toString());
    }

    @After
    public void after() {
        TestBaseUtils.compareResultsByLinesInMemory((String)this.expected(), (String)this.resultPath());
    }

    @Test
    public void testAllRejectingFilter() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet filterDs = ds.filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)FilterITCase.$anonfun$testAllRejectingFilter$1(t)));
        String x$5 = this.resultPath();
        FileSystem.WriteMode x$6 = FileSystem.WriteMode.OVERWRITE;
        String x$7 = filterDs.writeAsCsv$default$2();
        String x$8 = filterDs.writeAsCsv$default$3();
        filterDs.writeAsCsv(x$5, x$7, x$8, x$6);
        env.execute();
        this.expected_$eq("\n");
    }

    @Test
    public void testAllPassingFilter() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet filterDs = ds.filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)FilterITCase.$anonfun$testAllPassingFilter$1(t)));
        String x$9 = this.resultPath();
        FileSystem.WriteMode x$10 = FileSystem.WriteMode.OVERWRITE;
        String x$11 = filterDs.writeAsCsv$default$2();
        String x$12 = filterDs.writeAsCsv$default$3();
        filterDs.writeAsCsv(x$9, x$11, x$12, x$10);
        env.execute();
        this.expected_$eq("1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n");
    }

    @Test
    public void testFilterOnStringTupleField() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet filterDs = ds.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FilterITCase.$anonfun$testFilterOnStringTupleField$1(x$1)));
        String x$13 = this.resultPath();
        FileSystem.WriteMode x$14 = FileSystem.WriteMode.OVERWRITE;
        String x$15 = filterDs.writeAsCsv$default$2();
        String x$16 = filterDs.writeAsCsv$default$3();
        filterDs.writeAsCsv(x$13, x$15, x$16, x$14);
        env.execute();
        this.expected_$eq("3,2,Hello world\n4,3,Hello world, how are you?\n");
    }

    @Test
    public void testFilterOnIntegerTupleField() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet filterDs = ds.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)FilterITCase.$anonfun$testFilterOnIntegerTupleField$1(x$2)));
        String x$17 = this.resultPath();
        FileSystem.WriteMode x$18 = FileSystem.WriteMode.OVERWRITE;
        String x$19 = filterDs.writeAsCsv$default$2();
        String x$20 = filterDs.writeAsCsv$default$3();
        filterDs.writeAsCsv(x$17, x$19, x$20, x$18);
        env.execute();
        this.expected_$eq("2,2,Hello\n4,3,Hello world, how are you?\n6,3,Luke Skywalker\n8,4,Comment#2\n10,4,Comment#4\n12,5,Comment#6\n14,5,Comment#8\n16,6,Comment#10\n18,6,Comment#12\n20,6,Comment#14\n");
    }

    @Test
    public void testFilterBasicType() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<String> ds = CollectionDataSets$.MODULE$.getStringDataSet(env);
        DataSet filterDs = ds.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.startsWith("H")));
        filterDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("Hi\nHello\nHello world\nHello world, how are you?\n");
    }

    @Test
    public void testFilterOnCustomType() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<CollectionDataSets.CustomType> ds = CollectionDataSets$.MODULE$.getCustomTypeDataSet(env);
        DataSet filterDs = ds.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FilterITCase.$anonfun$testFilterOnCustomType$1(x$4)));
        filterDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("3,3,Hello world, how are you?\n3,4,I am fine.\n3,5,Luke Skywalker\n");
    }

    @Test
    public void testRichFilterOnStringTupleField() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Object> ints = CollectionDataSets$.MODULE$.getIntDataSet(env);
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet filterDs = ds.filter((FilterFunction)new RichFilterFunction<Tuple3<Object, Object, String>>(null){
            private int literal;

            public int literal() {
                return this.literal;
            }

            public void literal_$eq(int x$1) {
                this.literal = x$1;
            }

            public void open(OpenContext openContext) {
                List ints = this.getRuntimeContext().getBroadcastVariable("ints");
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ints).asScala()).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.literal_$eq(this.literal() < i ? i : this.literal()));
            }

            public boolean filter(Tuple3<Object, Object, String> value) {
                return BoxesRunTime.unboxToInt((Object)value._1()) < this.literal();
            }
            {
                this.literal = -1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$open$1(org.apache.flink.api.scala.operators.FilterITCase$$anon$1 int )}, serializedLambda);
            }
        }).withBroadcastSet(ints, "ints");
        String x$21 = this.resultPath();
        FileSystem.WriteMode x$22 = FileSystem.WriteMode.OVERWRITE;
        String x$23 = filterDs.writeAsCsv$default$2();
        String x$24 = filterDs.writeAsCsv$default$3();
        filterDs.writeAsCsv(x$21, x$23, x$24, x$22);
        env.execute();
        this.expected_$eq("1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n");
    }

    public static final /* synthetic */ boolean $anonfun$testAllRejectingFilter$1(Tuple3 t) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testAllPassingFilter$1(Tuple3 t) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testFilterOnStringTupleField$1(Tuple3 x$1) {
        return ((String)x$1._3()).contains("world");
    }

    public static final /* synthetic */ boolean $anonfun$testFilterOnIntegerTupleField$1(Tuple3 x$2) {
        return BoxesRunTime.unboxToInt((Object)x$2._1()) % 2 == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testFilterOnCustomType$1(CollectionDataSets.CustomType x$4) {
        return x$4.myString().contains("a");
    }

    public FilterITCase(MultipleProgramsTestBaseJUnit4.TestExecutionMode mode) {
        super(mode);
    }
}

