/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.connector.source.lib.util;

import java.util.concurrent.CompletionStage;
import org.apache.flink.api.connector.source.util.ratelimit.GatedRateLimiter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class GatedRateLimiterTest {
    GatedRateLimiterTest() {
    }

    @Test
    void testCapacityNotExceededOnCheckpoint() {
        int capacityPerCycle = 5;
        GatedRateLimiter gatedRateLimiter = new GatedRateLimiter(capacityPerCycle);
        for (int x = 0; x < capacityPerCycle; ++x) {
            Assertions.assertThat((CompletionStage)gatedRateLimiter.acquire()).isCompleted();
        }
        CompletionStage postInitialBatch = gatedRateLimiter.acquire();
        Assertions.assertThat((CompletionStage)postInitialBatch).isNotCompleted();
        gatedRateLimiter.notifyCheckpointComplete(0L);
        Assertions.assertThat((CompletionStage)postInitialBatch).isCompleted();
        for (int x = 0; x < capacityPerCycle - 1; ++x) {
            Assertions.assertThat((CompletionStage)gatedRateLimiter.acquire()).isCompleted();
        }
        CompletionStage postCheckpoint = gatedRateLimiter.acquire();
        Assertions.assertThat((CompletionStage)postCheckpoint).isNotCompleted();
    }
}

