/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.streaming.api.datastream;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.flink.api.common.eventtime.SerializableTimestampAssigner;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.lib.NumberSequenceSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class WatermarkAlignmentITCase {
    WatermarkAlignmentITCase() {
    }

    @Test
    void testTaskFinishedWithWatermarkAlignmentExecution() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(2);
        SingleOutputStreamOperator stream = env.fromSource((Source)new NumberSequenceSource(0L, 100L), WatermarkStrategy.forMonotonousTimestamps().withTimestampAssigner((SerializableTimestampAssigner & Serializable)(aLong, l) -> aLong).withWatermarkAlignment("g1", Duration.ofMillis(10L), Duration.ofSeconds(2L)), "Sequence Source").filter((FilterFunction & Serializable)aLong -> true);
        List result = stream.executeAndCollect(101);
        Collections.sort(result);
        Assertions.assertIterableEquals((Iterable)result, (Iterable)LongStream.rangeClosed(0L, 100L).boxed().collect(Collectors.toList()));
    }
}

