/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.streaming.api;

import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.formats.avro.typeutils.GenericRecordAvroTypeInfo;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class StreamExecutionEnvironmentITCase {
    @RegisterExtension
    public static final MiniClusterExtension MINI_CLUSTER = new MiniClusterExtension(new MiniClusterResourceConfiguration.Builder().setNumberTaskManagers(1).setNumberSlotsPerTaskManager(1).build());

    @Test
    public void executeThrowsProgramInvocationException() {
        Configuration config = new Configuration(MINI_CLUSTER.getClientConfiguration());
        config.set(DeploymentOptions.TARGET, (Object)"remote");
        config.set(DeploymentOptions.ATTACHED, (Object)true);
        StreamExecutionEnvironment env = new StreamExecutionEnvironment(config);
        env.fromData((Object[])new String[]{"hello"}).map((MapFunction & Serializable)in -> {
            throw new RuntimeException("Failing");
        }).print();
        Assertions.assertThatThrownBy(() -> ((StreamExecutionEnvironment)env).execute()).isInstanceOf(ProgramInvocationException.class);
    }

    @Test
    void testAvroGenericRecordsInFromElementsDoesNotFailDueToKryoFallback() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        Schema schema = this.getSchemaFromResources("/avro/user.avsc");
        GenericData.Record user1 = new GenericRecordBuilder(schema).set("name", (Object)"Foo").set("age", (Object)40).build();
        GenericData.Record user2 = new GenericRecordBuilder(schema).set("name", (Object)"Bar").set("age", (Object)45).build();
        Object[] data = new GenericRecord[]{user1, user2};
        DataStreamSource stream = env.fromData((TypeInformation)new GenericRecordAvroTypeInfo(schema), data);
        List result = stream.executeAndCollect(data.length + 1);
        Assertions.assertThat((List)result).containsExactly(data);
    }

    @Test
    void testAvroGenericRecordsInFromElementsDoesNotFailDueToKryoFallbackUsingReturns() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        Schema schema = this.getSchemaFromResources("/avro/user.avsc");
        GenericData.Record user1 = new GenericRecordBuilder(schema).set("name", (Object)"Foo").set("age", (Object)40).build();
        GenericData.Record user2 = new GenericRecordBuilder(schema).set("name", (Object)"Bar").set("age", (Object)45).build();
        Object[] data = new GenericRecord[]{user1, user2};
        SingleOutputStreamOperator stream = env.fromData(data).returns((TypeInformation)new GenericRecordAvroTypeInfo(schema));
        List result = stream.executeAndCollect(data.length + 1);
        Assertions.assertThat((List)result).containsExactly(data);
    }

    private Schema getSchemaFromResources(String path) throws Exception {
        try (InputStream schemaStream = this.getClass().getResourceAsStream(path);){
            if (schemaStream == null) {
                throw new IllegalStateException("Could not find " + path + " in classpath");
            }
            Schema schema = new Schema.Parser().parse(schemaStream);
            return schema;
        }
    }
}

