/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.operators;

import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichFlatJoinFunction;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.TwoInputUdfOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.tuple.Tuple7;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.test.operators.util.CollectionDataSets;
import org.apache.flink.test.util.MultipleProgramsTestBaseJUnit4;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.util.Collector;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class OuterJoinITCase
extends MultipleProgramsTestBaseJUnit4 {
    public OuterJoinITCase(MultipleProgramsTestBaseJUnit4.TestExecutionMode mode) {
        super(mode);
    }

    @Test
    public void testLeftOuterJoin1() throws Exception {
        this.testLeftOuterJoinOnTuplesWithKeyPositions(JoinOperatorBase.JoinHint.REPARTITION_SORT_MERGE);
    }

    @Test
    public void testLeftOuterJoin2() throws Exception {
        this.testLeftOuterJoinOnTuplesWithKeyPositions(JoinOperatorBase.JoinHint.REPARTITION_HASH_FIRST);
    }

    @Test
    public void testLeftOuterJoin3() throws Exception {
        this.testLeftOuterJoinOnTuplesWithKeyPositions(JoinOperatorBase.JoinHint.REPARTITION_HASH_SECOND);
    }

    @Test
    public void testLeftOuterJoin4() throws Exception {
        this.testLeftOuterJoinOnTuplesWithKeyPositions(JoinOperatorBase.JoinHint.BROADCAST_HASH_SECOND);
    }

    @Test(expected=InvalidProgramException.class)
    public void testLeftOuterJoin5() throws Exception {
        this.testLeftOuterJoinOnTuplesWithKeyPositions(JoinOperatorBase.JoinHint.BROADCAST_HASH_FIRST);
    }

    private void testLeftOuterJoinOnTuplesWithKeyPositions(JoinOperatorBase.JoinHint hint) throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds1 = CollectionDataSets.getSmall3TupleDataSet(env);
        DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds2 = CollectionDataSets.getSmall5TupleDataSet(env);
        JoinOperator joinDs = ds1.leftOuterJoin(ds2, hint).where(new int[]{0}).equalTo(new int[]{0}).with((FlatJoinFunction)new T3T5FlatJoin());
        List result = joinDs.collect();
        String expected = "Hi,Hallo\nHello,Hallo Welt\nHello,Hallo Welt wie\nHello world,null\n";
        TestBaseUtils.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testRightOuterJoin1() throws Exception {
        this.testRightOuterJoinOnTuplesWithKeyPositions(JoinOperatorBase.JoinHint.REPARTITION_SORT_MERGE);
    }

    @Test
    public void testRightOuterJoin2() throws Exception {
        this.testRightOuterJoinOnTuplesWithKeyPositions(JoinOperatorBase.JoinHint.REPARTITION_HASH_FIRST);
    }

    @Test
    public void testRightOuterJoin3() throws Exception {
        this.testRightOuterJoinOnTuplesWithKeyPositions(JoinOperatorBase.JoinHint.REPARTITION_HASH_SECOND);
    }

    @Test
    public void testRightOuterJoin4() throws Exception {
        this.testRightOuterJoinOnTuplesWithKeyPositions(JoinOperatorBase.JoinHint.BROADCAST_HASH_FIRST);
    }

    @Test(expected=InvalidProgramException.class)
    public void testRightOuterJoin5() throws Exception {
        this.testRightOuterJoinOnTuplesWithKeyPositions(JoinOperatorBase.JoinHint.BROADCAST_HASH_SECOND);
    }

    private void testRightOuterJoinOnTuplesWithKeyPositions(JoinOperatorBase.JoinHint hint) throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds1 = CollectionDataSets.getSmall3TupleDataSet(env);
        DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds2 = CollectionDataSets.getSmall5TupleDataSet(env);
        JoinOperator joinDs = ds1.rightOuterJoin(ds2, hint).where(new int[]{1}).equalTo(new int[]{1}).with((FlatJoinFunction)new T3T5FlatJoin());
        List result = joinDs.collect();
        String expected = "Hi,Hallo\nHello,Hallo Welt\nnull,Hallo Welt wie\nHello world,Hallo Welt\n";
        TestBaseUtils.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testFullOuterJoin1() throws Exception {
        this.testFullOuterJoinOnTuplesWithKeyPositions(JoinOperatorBase.JoinHint.REPARTITION_SORT_MERGE);
    }

    @Test
    public void testFullOuterJoin2() throws Exception {
        this.testFullOuterJoinOnTuplesWithKeyPositions(JoinOperatorBase.JoinHint.REPARTITION_HASH_FIRST);
    }

    @Test
    public void testFullOuterJoin3() throws Exception {
        this.testFullOuterJoinOnTuplesWithKeyPositions(JoinOperatorBase.JoinHint.REPARTITION_HASH_SECOND);
    }

    @Test(expected=InvalidProgramException.class)
    public void testFullOuterJoin4() throws Exception {
        this.testFullOuterJoinOnTuplesWithKeyPositions(JoinOperatorBase.JoinHint.BROADCAST_HASH_FIRST);
    }

    @Test(expected=InvalidProgramException.class)
    public void testFullOuterJoin5() throws Exception {
        this.testFullOuterJoinOnTuplesWithKeyPositions(JoinOperatorBase.JoinHint.BROADCAST_HASH_SECOND);
    }

    private void testFullOuterJoinOnTuplesWithKeyPositions(JoinOperatorBase.JoinHint hint) throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds1 = CollectionDataSets.getSmall3TupleDataSet(env);
        DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds2 = CollectionDataSets.getSmall5TupleDataSet(env);
        JoinOperator joinDs = ds1.fullOuterJoin(ds2, hint).where(new int[]{0}).equalTo(new int[]{2}).with((FlatJoinFunction)new T3T5FlatJoin());
        List result = joinDs.collect();
        String expected = "null,Hallo\nHi,Hallo Welt\nHello,Hallo Welt wie\nHello world,null\n";
        TestBaseUtils.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testJoinOnTuplesWithCompositeKeyPositions() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds1 = CollectionDataSets.getSmall3TupleDataSet(env);
        DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds2 = CollectionDataSets.getSmall5TupleDataSet(env);
        JoinOperator joinDs = ds1.fullOuterJoin(ds2).where(new int[]{0, 1}).equalTo(new int[]{0, 4}).with((FlatJoinFunction)new T3T5FlatJoin());
        List result = joinDs.collect();
        String expected = "Hi,Hallo\nHello,Hallo Welt\nHello world,null\nnull,Hallo Welt wie\n";
        TestBaseUtils.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testJoinWithBroadcastSet() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Integer> intDs = CollectionDataSets.getIntegerDataSet(env);
        DataSet<Tuple3<Integer, Long, String>> ds1 = CollectionDataSets.getSmall3TupleDataSet(env);
        DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds2 = CollectionDataSets.getSmall5TupleDataSet(env);
        TwoInputUdfOperator joinDs = ds1.fullOuterJoin(ds2).where(new int[]{1}).equalTo(new int[]{4}).with((FlatJoinFunction)new T3T5BCJoin()).withBroadcastSet(intDs, "ints");
        List result = joinDs.collect();
        String expected = "Hi,Hallo,55\nHi,Hallo Welt wie,55\nHello,Hallo Welt,55\nHello world,Hallo Welt,55\n";
        TestBaseUtils.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testJoinWithMixedKeyTypes1() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CollectionDataSets.CustomType> ds1 = CollectionDataSets.getSmallCustomTypeDataSet(env);
        DataSet<Tuple3<Integer, Long, String>> ds2 = CollectionDataSets.getSmall3TupleDataSet(env);
        JoinOperator joinDs = ds1.fullOuterJoin(ds2).where((KeySelector)new KeySelector1()).equalTo(new int[]{0}).with((JoinFunction)new CustT3Join());
        List result = joinDs.collect();
        String expected = "Hi,Hi\nHello,Hello\nHello world,Hello\nnull,Hello world\n";
        TestBaseUtils.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testJoinWithMixedKeyTypes2() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds1 = CollectionDataSets.getSmall3TupleDataSet(env);
        DataSet<CollectionDataSets.CustomType> ds2 = CollectionDataSets.getSmallCustomTypeDataSet(env);
        JoinOperator joinDs = ds1.fullOuterJoin(ds2).where(new int[]{1}).equalTo((KeySelector)new KeySelector2()).with((JoinFunction)new T3CustJoin());
        List result = joinDs.collect();
        String expected = "null,Hi\nHi,Hello\nHello,Hello world\nHello world,Hello world\n";
        TestBaseUtils.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testJoinWithTupleReturningKeySelectors() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds1 = CollectionDataSets.getSmall3TupleDataSet(env);
        DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds2 = CollectionDataSets.getSmall5TupleDataSet(env);
        JoinOperator joinDs = ds1.fullOuterJoin(ds2).where((KeySelector)new KeySelector3()).equalTo((KeySelector)new KeySelector4()).with((FlatJoinFunction)new T3T5FlatJoin());
        List result = joinDs.collect();
        String expected = "Hi,Hallo\nHello,Hallo Welt\nHello world,null\nnull,Hallo Welt wie\n";
        TestBaseUtils.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testJoinWithNestedKeyExpression1() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CollectionDataSets.POJO> ds1 = CollectionDataSets.getSmallPojoDataSet(env);
        DataSet<Tuple7<Integer, String, Integer, Integer, Long, String, Long>> ds2 = CollectionDataSets.getSmallTuplebasedDataSet(env);
        JoinOperator joinDs = ds1.fullOuterJoin(ds2).where(new String[]{"nestedPojo.longNumber"}).equalTo(new String[]{"f6"}).with(new ProjectBothFunction());
        List result = joinDs.collect();
        String expected = "1 First (10,100,1000,One) 10000,(1,First,10,100,1000,One,10000)\n2 Second (20,200,2000,Two) 20000,(2,Second,20,200,2000,Two,20000)\n3 Third (30,300,3000,Three) 30000,(3,Third,30,300,3000,Three,30000)\n";
        TestBaseUtils.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testJoinWithNestedKeyExpression2() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CollectionDataSets.POJO> ds1 = CollectionDataSets.getSmallPojoDataSet(env);
        DataSet<Tuple7<Integer, String, Integer, Integer, Long, String, Long>> ds2 = CollectionDataSets.getSmallTuplebasedDataSet(env);
        JoinOperator joinDs = ds1.fullOuterJoin(ds2).where(new String[]{"nestedPojo.longNumber"}).equalTo(new int[]{6}).with(new ProjectBothFunction());
        List result = joinDs.collect();
        String expected = "1 First (10,100,1000,One) 10000,(1,First,10,100,1000,One,10000)\n2 Second (20,200,2000,Two) 20000,(2,Second,20,200,2000,Two,20000)\n3 Third (30,300,3000,Three) 30000,(3,Third,30,300,3000,Three,30000)\n";
        TestBaseUtils.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testJoinWithCompositeKeyExpressions() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CollectionDataSets.POJO> ds1 = CollectionDataSets.getSmallPojoDataSet(env);
        DataSet<Tuple7<Integer, String, Integer, Integer, Long, String, Long>> ds2 = CollectionDataSets.getSmallTuplebasedDataSet(env);
        JoinOperator joinDs = ds1.fullOuterJoin(ds2).where(new String[]{"nestedPojo.longNumber", "number", "str"}).equalTo(new String[]{"f6", "f0", "f1"}).with(new ProjectBothFunction());
        env.setParallelism(1);
        List result = joinDs.collect();
        String expected = "1 First (10,100,1000,One) 10000,(1,First,10,100,1000,One,10000)\n2 Second (20,200,2000,Two) 20000,(2,Second,20,200,2000,Two,20000)\n3 Third (30,300,3000,Three) 30000,(3,Third,30,300,3000,Three,30000)\n";
        TestBaseUtils.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testNestedIntoTuple() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CollectionDataSets.POJO> ds1 = CollectionDataSets.getSmallPojoDataSet(env);
        DataSet<Tuple7<Integer, String, Integer, Integer, Long, String, Long>> ds2 = CollectionDataSets.getSmallTuplebasedDataSet(env);
        JoinOperator joinDs = ds1.fullOuterJoin(ds2).where(new String[]{"nestedPojo.longNumber", "number", "nestedTupleWithCustom.f0"}).equalTo(new String[]{"f6", "f0", "f2"}).with(new ProjectBothFunction());
        env.setParallelism(1);
        List result = joinDs.collect();
        String expected = "1 First (10,100,1000,One) 10000,(1,First,10,100,1000,One,10000)\n2 Second (20,200,2000,Two) 20000,(2,Second,20,200,2000,Two,20000)\n3 Third (30,300,3000,Three) 30000,(3,Third,30,300,3000,Three,30000)\n";
        TestBaseUtils.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testNestedIntoTupleIntoPojo() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CollectionDataSets.POJO> ds1 = CollectionDataSets.getSmallPojoDataSet(env);
        DataSet<Tuple7<Integer, String, Integer, Integer, Long, String, Long>> ds2 = CollectionDataSets.getSmallTuplebasedDataSet(env);
        JoinOperator joinDs = ds1.fullOuterJoin(ds2).where(new String[]{"nestedTupleWithCustom.f0", "nestedTupleWithCustom.f1.myInt", "nestedTupleWithCustom.f1.myLong"}).equalTo(new String[]{"f2", "f3", "f4"}).with(new ProjectBothFunction());
        env.setParallelism(1);
        List result = joinDs.collect();
        String expected = "1 First (10,100,1000,One) 10000,(1,First,10,100,1000,One,10000)\n2 Second (20,200,2000,Two) 20000,(2,Second,20,200,2000,Two,20000)\n3 Third (30,300,3000,Three) 30000,(3,Third,30,300,3000,Three,30000)\n";
        TestBaseUtils.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testNonPojoToVerifyFullTupleKeys() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Tuple2<Integer, Integer>, String>> ds1 = CollectionDataSets.getSmallNestedTupleDataSet(env);
        DataSet<Tuple2<Tuple2<Integer, Integer>, String>> ds2 = CollectionDataSets.getSmallNestedTupleDataSet(env);
        JoinOperator joinDs = ds1.fullOuterJoin(ds2).where(new int[]{0}).equalTo(new String[]{"f0.f0", "f0.f1"}).with(new ProjectBothFunction());
        env.setParallelism(1);
        List result = joinDs.collect();
        String expected = "((1,1),one),((1,1),one)\n((2,2),two),((2,2),two)\n((3,3),three),((3,3),three)\n";
        TestBaseUtils.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testNonPojoToVerifyNestedTupleElementSelection() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Tuple2<Integer, Integer>, String>> ds1 = CollectionDataSets.getSmallNestedTupleDataSet(env);
        DataSet<Tuple2<Tuple2<Integer, Integer>, String>> ds2 = CollectionDataSets.getSmallNestedTupleDataSet(env);
        JoinOperator joinDs = ds1.fullOuterJoin(ds2).where(new String[]{"f0.f0"}).equalTo(new String[]{"f0.f0"}).with(new ProjectBothFunction());
        env.setParallelism(1);
        List result = joinDs.collect();
        String expected = "((1,1),one),((1,1),one)\n((2,2),two),((2,2),two)\n((3,3),three),((3,3),three)\n";
        TestBaseUtils.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testFullPojoWithFullTuple() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CollectionDataSets.POJO> ds1 = CollectionDataSets.getSmallPojoDataSet(env);
        DataSet<Tuple7<Long, Integer, Integer, Long, String, Integer, String>> ds2 = CollectionDataSets.getSmallTuplebasedDataSetMatchingPojo(env);
        JoinOperator joinDs = ds1.fullOuterJoin(ds2).where(new String[]{"*"}).equalTo(new String[]{"*"}).with(new ProjectBothFunction());
        env.setParallelism(1);
        List result = joinDs.collect();
        String expected = "1 First (10,100,1000,One) 10000,(10000,10,100,1000,One,1,First)\n2 Second (20,200,2000,Two) 20000,(20000,20,200,2000,Two,2,Second)\n3 Third (30,300,3000,Three) 30000,(30000,30,300,3000,Three,3,Third)\n";
        TestBaseUtils.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testJoinWithAtomicType1() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds1 = CollectionDataSets.getSmall3TupleDataSet(env);
        DataSource ds2 = env.fromElements((Object[])new Integer[]{1, 2});
        TwoInputUdfOperator joinDs = ds1.fullOuterJoin((DataSet)ds2).where(new int[]{0}).equalTo(new String[]{"*"}).with(new ProjectBothFunction()).returns((TypeInformation)new GenericTypeInfo(Tuple2.class));
        List result = joinDs.collect();
        String expected = "(1,1,Hi),1\n(2,2,Hello),2\n(3,2,Hello world),null\n";
        TestBaseUtils.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testJoinWithAtomicType2() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromElements((Object[])new Integer[]{1, 2});
        DataSet<Tuple3<Integer, Long, String>> ds2 = CollectionDataSets.getSmall3TupleDataSet(env);
        TwoInputUdfOperator joinDs = ds1.fullOuterJoin(ds2).where(new String[]{"*"}).equalTo(new int[]{0}).with(new ProjectBothFunction()).returns((TypeInformation)new GenericTypeInfo(Tuple2.class));
        List result = joinDs.collect();
        String expected = "1,(1,1,Hi)\n2,(2,2,Hello)\nnull,(3,2,Hello world)\n";
        TestBaseUtils.compareResultAsTuples((List)result, (String)expected);
    }

    private static class ProjectBothFunction<IN1, IN2>
    implements JoinFunction<IN1, IN2, Tuple2<IN1, IN2>> {
        private ProjectBothFunction() {
        }

        public Tuple2<IN1, IN2> join(IN1 first, IN2 second) throws Exception {
            return new Tuple2(first, second);
        }
    }

    private static class CustT3Join
    implements JoinFunction<CollectionDataSets.CustomType, Tuple3<Integer, Long, String>, Tuple2<String, String>> {
        private CustT3Join() {
        }

        public Tuple2<String, String> join(CollectionDataSets.CustomType first, Tuple3<Integer, Long, String> second) {
            return new Tuple2((Object)(first == null ? null : first.myString), second == null ? null : (String)second.f2);
        }
    }

    private static class T3CustJoin
    implements JoinFunction<Tuple3<Integer, Long, String>, CollectionDataSets.CustomType, Tuple2<String, String>> {
        private T3CustJoin() {
        }

        public Tuple2<String, String> join(Tuple3<Integer, Long, String> first, CollectionDataSets.CustomType second) {
            return new Tuple2((Object)(first == null ? null : (String)first.f2), (Object)(second == null ? null : second.myString));
        }
    }

    private static class T3T5BCJoin
    extends RichFlatJoinFunction<Tuple3<Integer, Long, String>, Tuple5<Integer, Long, Integer, String, Long>, Tuple3<String, String, Integer>> {
        private int broadcast;

        private T3T5BCJoin() {
        }

        public void open(OpenContext openContext) {
            List ints = this.getRuntimeContext().getBroadcastVariable("ints");
            int sum = 0;
            for (Integer i : ints) {
                sum += i.intValue();
            }
            this.broadcast = sum;
        }

        public void join(Tuple3<Integer, Long, String> first, Tuple5<Integer, Long, Integer, String, Long> second, Collector<Tuple3<String, String, Integer>> out) throws Exception {
            out.collect((Object)new Tuple3((Object)(first == null ? null : (String)first.f2), (Object)(second == null ? null : (String)second.f3), (Object)this.broadcast));
        }
    }

    private static class T3T5FlatJoin
    implements FlatJoinFunction<Tuple3<Integer, Long, String>, Tuple5<Integer, Long, Integer, String, Long>, Tuple2<String, String>> {
        private T3T5FlatJoin() {
        }

        public void join(Tuple3<Integer, Long, String> first, Tuple5<Integer, Long, Integer, String, Long> second, Collector<Tuple2<String, String>> out) {
            out.collect((Object)new Tuple2((Object)(first == null ? null : (String)first.f2), second == null ? null : (String)second.f3));
        }
    }

    private static class KeySelector4
    implements KeySelector<Tuple5<Integer, Long, Integer, String, Long>, Tuple2<Integer, Long>> {
        private static final long serialVersionUID = 1L;

        private KeySelector4() {
        }

        public Tuple2<Integer, Long> getKey(Tuple5<Integer, Long, Integer, String, Long> t) {
            return new Tuple2(t.f0, t.f4);
        }
    }

    private static class KeySelector3
    implements KeySelector<Tuple3<Integer, Long, String>, Tuple2<Integer, Long>> {
        private static final long serialVersionUID = 1L;

        private KeySelector3() {
        }

        public Tuple2<Integer, Long> getKey(Tuple3<Integer, Long, String> t) {
            return new Tuple2(t.f0, t.f1);
        }
    }

    private static class KeySelector2
    implements KeySelector<CollectionDataSets.CustomType, Long> {
        private KeySelector2() {
        }

        public Long getKey(CollectionDataSets.CustomType value) {
            return value.myLong;
        }
    }

    private static class KeySelector1
    implements KeySelector<CollectionDataSets.CustomType, Integer> {
        private KeySelector1() {
        }

        public Integer getKey(CollectionDataSets.CustomType value) {
            return value.myInt;
        }
    }
}

