/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.operators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.ReduceOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.test.util.MultipleProgramsTestBaseJUnit4;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ObjectReuseITCase
extends MultipleProgramsTestBaseJUnit4 {
    private static final List<Tuple2<String, Integer>> REDUCE_DATA = Arrays.asList(new Tuple2((Object)"a", (Object)1), new Tuple2((Object)"a", (Object)2), new Tuple2((Object)"a", (Object)3), new Tuple2((Object)"a", (Object)4), new Tuple2((Object)"a", (Object)50));
    private static final List<Tuple2<String, Integer>> GROUP_REDUCE_DATA = Arrays.asList(new Tuple2((Object)"a", (Object)1), new Tuple2((Object)"a", (Object)2), new Tuple2((Object)"a", (Object)3), new Tuple2((Object)"a", (Object)4), new Tuple2((Object)"a", (Object)5));
    private final boolean objectReuse;

    public ObjectReuseITCase(boolean objectReuse) {
        super(MultipleProgramsTestBaseJUnit4.TestExecutionMode.CLUSTER);
        this.objectReuse = objectReuse;
    }

    @Test
    public void testKeyedReduce() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        if (this.objectReuse) {
            env.getConfig().enableObjectReuse();
        } else {
            env.getConfig().disableObjectReuse();
        }
        DataSource input = env.fromCollection(REDUCE_DATA);
        ReduceOperator result = input.groupBy(new int[]{0}).reduce((ReduceFunction)new ReduceFunction<Tuple2<String, Integer>>(){

            public Tuple2<String, Integer> reduce(Tuple2<String, Integer> value1, Tuple2<String, Integer> value2) {
                Tuple2<String, Integer> tuple2 = value2;
                tuple2.f1 = (Integer)tuple2.f1 + (Integer)value1.f1;
                return value2;
            }
        });
        Tuple2 res = (Tuple2)result.collect().get(0);
        Assert.assertEquals((Object)new Tuple2((Object)"a", (Object)60), (Object)res);
    }

    @Test
    public void testGlobalReduce() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        if (this.objectReuse) {
            env.getConfig().enableObjectReuse();
        } else {
            env.getConfig().disableObjectReuse();
        }
        DataSource input = env.fromCollection(REDUCE_DATA);
        ReduceOperator result = input.reduce((ReduceFunction)new ReduceFunction<Tuple2<String, Integer>>(){

            public Tuple2<String, Integer> reduce(Tuple2<String, Integer> value1, Tuple2<String, Integer> value2) {
                if ((Integer)value1.f1 % 3 == 0) {
                    Tuple2<String, Integer> tuple2 = value1;
                    tuple2.f1 = (Integer)tuple2.f1 + (Integer)value2.f1;
                    return value1;
                }
                Tuple2<String, Integer> tuple2 = value2;
                tuple2.f1 = (Integer)tuple2.f1 + (Integer)value1.f1;
                return value2;
            }
        });
        Tuple2 res = (Tuple2)result.collect().get(0);
        Assert.assertEquals((Object)new Tuple2((Object)"a", (Object)60), (Object)res);
    }

    @Test
    public void testKeyedGroupReduce() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        if (this.objectReuse) {
            env.getConfig().enableObjectReuse();
        } else {
            env.getConfig().disableObjectReuse();
        }
        DataSource input = env.fromCollection(GROUP_REDUCE_DATA);
        GroupReduceOperator result = input.groupBy(new int[]{0}).reduceGroup((GroupReduceFunction)new GroupReduceFunction<Tuple2<String, Integer>, Tuple2<String, Integer>>(){

            public void reduce(Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) {
                ArrayList<Tuple2<String, Integer>> list = new ArrayList<Tuple2<String, Integer>>();
                for (Tuple2<String, Integer> tuple2 : values) {
                    list.add(tuple2);
                }
                for (Tuple2 tuple2 : list) {
                    out.collect((Object)tuple2);
                }
            }
        });
        List is = result.collect();
        Collections.sort(is, new TestBaseUtils.TupleComparator());
        List<Tuple2> expected = env.getConfig().isObjectReuseEnabled() ? Arrays.asList(new Tuple2((Object)"a", (Object)4), new Tuple2((Object)"a", (Object)4), new Tuple2((Object)"a", (Object)5), new Tuple2((Object)"a", (Object)5), new Tuple2((Object)"a", (Object)5)) : Arrays.asList(new Tuple2((Object)"a", (Object)1), new Tuple2((Object)"a", (Object)2), new Tuple2((Object)"a", (Object)3), new Tuple2((Object)"a", (Object)4), new Tuple2((Object)"a", (Object)5));
        Assert.assertEquals(expected, (Object)is);
    }

    @Test
    public void testGlobalGroupReduce() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        if (this.objectReuse) {
            env.getConfig().enableObjectReuse();
        } else {
            env.getConfig().disableObjectReuse();
        }
        DataSource input = env.fromCollection(GROUP_REDUCE_DATA);
        GroupReduceOperator result = input.reduceGroup((GroupReduceFunction)new GroupReduceFunction<Tuple2<String, Integer>, Tuple2<String, Integer>>(){

            public void reduce(Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) {
                ArrayList<Tuple2<String, Integer>> list = new ArrayList<Tuple2<String, Integer>>();
                for (Tuple2<String, Integer> tuple2 : values) {
                    list.add(tuple2);
                }
                for (Tuple2 tuple2 : list) {
                    out.collect((Object)tuple2);
                }
            }
        });
        List is = result.collect();
        Collections.sort(is, new TestBaseUtils.TupleComparator());
        List<Tuple2> expected = env.getConfig().isObjectReuseEnabled() ? Arrays.asList(new Tuple2((Object)"a", (Object)4), new Tuple2((Object)"a", (Object)4), new Tuple2((Object)"a", (Object)5), new Tuple2((Object)"a", (Object)5), new Tuple2((Object)"a", (Object)5)) : Arrays.asList(new Tuple2((Object)"a", (Object)1), new Tuple2((Object)"a", (Object)2), new Tuple2((Object)"a", (Object)3), new Tuple2((Object)"a", (Object)4), new Tuple2((Object)"a", (Object)5));
        Assert.assertEquals(expected, (Object)is);
    }

    @Parameterized.Parameters(name="Execution mode = CLUSTER, Reuse = {0}")
    public static Collection<Object[]> executionModes() {
        return Arrays.asList({false}, {true});
    }
}

