/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.iterative;

import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.IterativeDataSet;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.test.util.JavaProgramTestBaseJUnit4;

public class StaticlyNestedIterationsITCase
extends JavaProgramTestBaseJUnit4 {
    protected void testProgram() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource data1 = env.generateSequence(1L, 100L);
        DataSource data2 = env.generateSequence(1L, 100L);
        IterativeDataSet firstIteration = data1.iterate(100);
        DataSet firstResult = firstIteration.closeWith((DataSet)firstIteration.map((MapFunction)new IdMapper()));
        IterativeDataSet mainIteration = data2.map((MapFunction)new IdMapper()).iterate(100);
        JoinOperator.EquiJoin joined = mainIteration.join(firstResult).where((KeySelector)new IdKeyExtractor()).equalTo((KeySelector)new IdKeyExtractor()).with((JoinFunction)new Joiner());
        DataSet mainResult = mainIteration.closeWith((DataSet)joined);
        mainResult.output((OutputFormat)new DiscardingOutputFormat());
        env.execute();
    }

    private static class Joiner
    implements JoinFunction<Long, Long, Long> {
        private static final long serialVersionUID = 1L;

        private Joiner() {
        }

        public Long join(Long first, Long second) {
            return first;
        }
    }

    private static class IdMapper
    implements MapFunction<Long, Long> {
        private static final long serialVersionUID = 1L;

        private IdMapper() {
        }

        public Long map(Long value) {
            return value;
        }
    }

    private static class IdKeyExtractor
    implements KeySelector<Long, Long> {
        private static final long serialVersionUID = 1L;

        private IdKeyExtractor() {
        }

        public Long getKey(Long value) {
            return value;
        }
    }
}

