/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.iterative;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DeltaIteration;
import org.apache.flink.api.java.operators.PartitionOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.test.util.MultipleProgramsTestBaseJUnit4;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SolutionSetDuplicatesITCase
extends MultipleProgramsTestBaseJUnit4 {
    public SolutionSetDuplicatesITCase(MultipleProgramsTestBaseJUnit4.TestExecutionMode mode) {
        super(mode);
    }

    @Test
    public void testProgram() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            PartitionOperator data = env.generateSequence(0L, 10L).flatMap((FlatMapFunction)new FlatMapFunction<Long, Tuple2<Long, Long>>(){

                public void flatMap(Long value, Collector<Tuple2<Long, Long>> out) {
                    out.collect((Object)new Tuple2((Object)value, (Object)value));
                    out.collect((Object)new Tuple2((Object)value, (Object)value));
                    out.collect((Object)new Tuple2((Object)value, (Object)value));
                }
            }).rebalance();
            DeltaIteration iter = data.iterateDelta((DataSet)data, 10, new int[]{0});
            List result = iter.closeWith((DataSet)iter.getWorkset(), (DataSet)iter.getWorkset()).map((MapFunction)new MapFunction<Tuple2<Long, Long>, Integer>(){

                public Integer map(Tuple2<Long, Long> value) {
                    return ((Long)value.f0).intValue();
                }
            }).collect();
            Assert.assertEquals((long)11L, (long)result.size());
            Collections.sort(result);
            Assert.assertEquals(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10), (Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

