/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.iterative;

import java.util.List;
import java.util.Locale;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.IterativeDataSet;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.examples.java.clustering.KMeans;
import org.apache.flink.test.testdata.KMeansData;
import org.apache.flink.test.util.JavaProgramTestBaseJUnit4;

public class KMeansWithBroadcastSetITCase
extends JavaProgramTestBaseJUnit4 {
    protected void testProgram() throws Exception {
        Object[] points = "0|50.90|16.20|\n1|73.65|61.76|\n2|61.73|49.95|\n3|1.60|70.11|\n4|2.43|19.81|\n5|67.99|9.00|\n6|87.80|84.49|\n7|90.26|42.99|\n8|51.36|6.16|\n9|12.43|9.52|\n10|80.01|8.78|\n11|92.76|2.93|\n12|46.32|100.00|\n13|34.11|45.61|\n14|68.82|16.36|\n15|81.47|76.45|\n16|65.55|40.21|\n17|84.22|88.56|\n18|36.99|68.36|\n19|28.87|37.69|\n20|31.56|13.22|\n21|18.49|34.45|\n22|13.33|94.02|\n23|91.19|81.62|\n24|85.78|39.02|\n25|94.41|47.07|\n26|90.62|10.43|\n27|31.52|85.81|\n28|24.65|77.98|\n29|69.34|75.79|\n30|22.56|78.61|\n31|91.74|83.82|\n32|76.64|89.53|\n33|36.02|73.01|\n34|87.86|18.94|\n35|91.94|34.61|\n36|12.52|47.01|\n37|44.01|26.19|\n38|26.20|73.36|\n39|15.21|17.37|\n40|27.96|94.81|\n41|26.44|44.81|\n42|53.29|26.69|\n43|23.94|11.50|n44|19.00|25.48|\n45|82.26|1.88|\n46|47.56|82.54|\n47|51.54|35.10|\n48|86.71|55.51|\n49|54.16|23.68|\n50|71.81|32.83|\n51|20.70|14.19|\n52|57.17|88.56|\n53|91.39|49.38|\n54|47.90|62.07|\n55|55.70|37.77|\n56|87.87|74.62|\n57|95.70|45.04|\n58|41.61|89.37|\n59|82.19|20.84|\n60|49.88|2.62|\n61|16.42|53.30|\n62|38.37|72.62|\n63|43.26|49.59|\n64|28.96|2.36|\n65|88.41|91.43|\n66|98.61|79.58|\n67|4.94|18.65|\n68|75.89|79.30|\n69|93.18|76.26|\n70|73.43|70.50|\n71|78.64|90.87|\n72|58.47|63.07|\n73|69.74|54.36|\n74|38.47|36.60|\n75|51.07|14.75|\n76|24.18|16.85|\n77|7.56|50.72|\n78|64.28|97.01|\n79|85.30|24.13|\n80|72.78|30.78|\n81|18.42|17.45|\n82|87.44|74.98|\n83|38.30|17.77|\n84|63.62|7.90|\n85|8.84|67.87|\n86|76.12|51.83|\n87|32.30|74.79|n88|41.73|45.34|\n89|58.13|18.43|\n90|98.10|33.46|\n91|17.76|4.10|\n92|60.58|18.15|\n93|50.11|33.25|\n94|97.74|60.93|\n95|76.31|52.50|\n96|7.71|85.85|\n97|9.32|72.21|\n98|71.29|51.88|\n99|31.39|7.27|".split("\n");
        Object[] centers = "0|1.96|65.04|\n1|53.99|84.23|\n2|97.28|74.50|\n3|63.57|24.53|\n4|28.10|43.27|\n5|99.51|62.70|\n6|30.31|30.36|".split("\n");
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        MapOperator pointsSet = env.fromElements(points).map((MapFunction)new MapFunction<String, KMeans.Point>(){

            public KMeans.Point map(String p) {
                String[] fields = p.split("\\|");
                return new KMeans.Point(Double.parseDouble(fields[1]), Double.parseDouble(fields[2]));
            }
        });
        MapOperator centroidsSet = env.fromElements(centers).map((MapFunction)new MapFunction<String, KMeans.Centroid>(){

            public KMeans.Centroid map(String c) {
                String[] fields = c.split("\\|");
                return new KMeans.Centroid(Integer.parseInt(fields[0]), Double.parseDouble(fields[1]), Double.parseDouble(fields[2]));
            }
        });
        IterativeDataSet loop = centroidsSet.iterate(20);
        MapOperator newCentroids = ((MapOperator)pointsSet.map((MapFunction)new KMeans.SelectNearestCenter()).withBroadcastSet((DataSet)loop, "centroids")).map((MapFunction)new KMeans.CountAppender()).groupBy(new int[]{0}).reduce((ReduceFunction)new KMeans.CentroidAccumulator()).map((MapFunction)new KMeans.CentroidAverager());
        DataSet finalCentroids = loop.closeWith((DataSet)newCentroids);
        MapOperator stringCentroids = finalCentroids.map((MapFunction)new MapFunction<KMeans.Centroid, String>(){

            public String map(KMeans.Centroid c) throws Exception {
                return String.format(Locale.US, "%d|%.2f|%.2f|", c.id, c.x, c.y);
            }
        });
        List result = stringCentroids.collect();
        KMeansData.checkResultsWithDelta((String)"0|15.80|79.42|\n1|43.11|78.20|\n2|83.13|82.18|\n3|65.70|18.49|\n4|25.13|44.42|\n5|82.90|48.16|\n6|20.79|13.08|", (List)result, (double)0.01);
    }
}

