/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.iterative;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.LocalCollectionOutputFormat;
import org.apache.flink.api.java.operators.DeltaIteration;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.test.util.JavaProgramTestBaseJUnit4;
import org.junit.Assert;

public class DeltaIterationNotDependingOnSolutionSetITCase
extends JavaProgramTestBaseJUnit4 {
    private final List<Tuple2<Long, Long>> result = new ArrayList<Tuple2<Long, Long>>();

    protected void testProgram() throws Exception {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            env.setParallelism(1);
            MapOperator input = env.generateSequence(0L, 9L).map(new Duplicator());
            DeltaIteration iteration = input.iterateDelta((DataSet)input, 5, new int[]{1});
            iteration.closeWith((DataSet)iteration.getWorkset(), (DataSet)iteration.getWorkset().map((MapFunction)new TestMapper())).output((OutputFormat)new LocalCollectionOutputFormat(this.result));
            env.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    protected void postSubmit() {
        boolean[] present = new boolean[50];
        for (Tuple2<Long, Long> t : this.result) {
            present[((Long)t.f0).intValue()] = true;
        }
        for (int i = 0; i < present.length; ++i) {
            Assert.assertTrue((String)String.format("Missing tuple (%d, %d)", i, i), (boolean)present[i]);
        }
    }

    private static final class TestMapper
    extends RichMapFunction<Tuple2<Long, Long>, Tuple2<Long, Long>> {
        private TestMapper() {
        }

        public Tuple2<Long, Long> map(Tuple2<Long, Long> value) {
            return new Tuple2((Object)((Long)value.f0 + 10L), (Object)((Long)value.f1 + 10L));
        }
    }

    private static final class Duplicator<T>
    implements MapFunction<T, Tuple2<T, T>> {
        private Duplicator() {
        }

        public Tuple2<T, T> map(T value) {
            return new Tuple2(value, value);
        }
    }
}

