/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.upserttest.sink;

import java.io.File;
import java.io.Serializable;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.connector.upserttest.sink.UpsertTestSinkBuilder;
import org.apache.flink.util.TestLoggerExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={TestLoggerExtension.class})
class UpsertTestSinkBuilderTest {
    @TempDir
    static File tempFile;

    UpsertTestSinkBuilderTest() {
    }

    @Test
    void testValidBuilder() {
        SerializationSchema & Serializable dummySerializationSchema = (SerializationSchema & Serializable)element -> null;
        UpsertTestSinkBuilder builder = new UpsertTestSinkBuilder().setOutputFile(tempFile).setKeySerializationSchema((SerializationSchema)dummySerializationSchema).setValueSerializationSchema((SerializationSchema)dummySerializationSchema);
        Assertions.assertThatNoException().isThrownBy(() -> ((UpsertTestSinkBuilder)builder).build());
    }

    @Test
    void testThrowIfFileNotSet() {
        SerializationSchema & Serializable dummySerializationSchema = (SerializationSchema & Serializable)element -> null;
        UpsertTestSinkBuilder builder = new UpsertTestSinkBuilder().setKeySerializationSchema((SerializationSchema)dummySerializationSchema).setValueSerializationSchema((SerializationSchema)dummySerializationSchema);
        Assertions.assertThatThrownBy(() -> ((UpsertTestSinkBuilder)builder).build()).isInstanceOf(NullPointerException.class);
    }

    @Test
    void testThrowIfKeySerializerNotSet() {
        SerializationSchema & Serializable dummySerializationSchema = (SerializationSchema & Serializable)element -> null;
        UpsertTestSinkBuilder builder = new UpsertTestSinkBuilder().setOutputFile(tempFile).setValueSerializationSchema((SerializationSchema)dummySerializationSchema);
        Assertions.assertThatThrownBy(() -> ((UpsertTestSinkBuilder)builder).build()).isInstanceOf(NullPointerException.class);
    }

    @Test
    void testThrowIfValueSerializerNotSet() {
        SerializationSchema & Serializable dummySerializationSchema = (SerializationSchema & Serializable)element -> null;
        UpsertTestSinkBuilder builder = new UpsertTestSinkBuilder().setOutputFile(tempFile).setValueSerializationSchema((SerializationSchema)dummySerializationSchema);
        Assertions.assertThatThrownBy(() -> ((UpsertTestSinkBuilder)builder).build()).isInstanceOf(NullPointerException.class);
    }
}

