/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.operators;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.operators.DistinctITCase$;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.api.scala.util.CollectionDataSets;
import org.apache.flink.api.scala.util.CollectionDataSets$;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.test.util.MultipleProgramsTestBaseJUnit4;
import org.apache.flink.test.util.TestBaseUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.Tuple1;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001B\u0001\u0003\u0001=\u0011a\u0002R5ti&t7\r^%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005Iq\u000e]3sCR|'o\u001d\u0006\u0003\u000b\u0019\tQa]2bY\u0006T!a\u0002\u0005\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E1R\"\u0001\n\u000b\u0005M!\u0012\u0001B;uS2T!!\u0006\u0005\u0002\tQ,7\u000f^\u0005\u0003/I\u0011a$T;mi&\u0004H.\u001a)s_\u001e\u0014\u0018-\\:UKN$()Y:f\u0015Vs\u0017\u000e\u001e\u001b\t\u0011e\u0001!\u0011!Q\u0001\ni\tA!\\8eKB\u00111D\b\b\u0003#qI!!\b\n\u0002=5+H\u000e^5qY\u0016\u0004&o\\4sC6\u001cH+Z:u\u0005\u0006\u001cXMS+oSR$\u0014BA\u0010!\u0005E!Vm\u001d;Fq\u0016\u001cW\u000f^5p]6{G-\u001a\u0006\u0003;IAQA\t\u0001\u0005\u0002\r\na\u0001P5oSRtDC\u0001\u0013'!\t)\u0003!D\u0001\u0003\u0011\u0015I\u0012\u00051\u0001\u001b\u0011\u001dA\u0003\u00011A\u0005\n%\n!B]3tk2$\b+\u0019;i+\u0005Q\u0003CA\u00164\u001d\ta\u0013\u0007\u0005\u0002.a5\taF\u0003\u00020\u001d\u00051AH]8pizR\u0011!B\u0005\u0003eA\na\u0001\u0015:fI\u00164\u0017B\u0001\u001b6\u0005\u0019\u0019FO]5oO*\u0011!\u0007\r\u0005\bo\u0001\u0001\r\u0011\"\u00039\u00039\u0011Xm];miB\u000bG\u000f[0%KF$\"!O\u001f\u0011\u0005iZT\"\u0001\u0019\n\u0005q\u0002$\u0001B+oSRDqA\u0010\u001c\u0002\u0002\u0003\u0007!&A\u0002yIEBa\u0001\u0011\u0001!B\u0013Q\u0013a\u0003:fgVdG\u000fU1uQ\u0002BqA\u0011\u0001A\u0002\u0013%\u0011&\u0001\u0005fqB,7\r^3e\u0011\u001d!\u0005\u00011A\u0005\n\u0015\u000bA\"\u001a=qK\u000e$X\rZ0%KF$\"!\u000f$\t\u000fy\u001a\u0015\u0011!a\u0001U!1\u0001\n\u0001Q!\n)\n\u0011\"\u001a=qK\u000e$X\r\u001a\u0011\t\u000f)\u0003!\u0019!C\u0005\u0017\u0006Yq\f^3na\u001a{G\u000eZ3s+\u0005a\u0005CA'S\u001b\u0005q%BA(Q\u0003\u0015\u0011X\u000f\\3t\u0015\t\tF\"A\u0003kk:LG/\u0003\u0002T\u001d\nyA+Z7q_J\f'/\u001f$pY\u0012,'\u000f\u0003\u0004V\u0001\u0001\u0006I\u0001T\u0001\r?R,W\u000e\u001d$pY\u0012,'\u000f\t\u0005\u0006/\u0002!\taS\u0001\u000bi\u0016l\u0007OR8mI\u0016\u0014\bF\u0001,Z!\tQ6,D\u0001Q\u0013\ta\u0006K\u0001\u0003Sk2,\u0007\"\u00020\u0001\t\u0003y\u0016A\u00022fM>\u0014X\rF\u0001:Q\ti\u0016\r\u0005\u0002[E&\u00111\r\u0015\u0002\u0007\u0005\u00164wN]3\t\u000b\u0015\u0004A\u0011A0\u0002\u000b\u00054G/\u001a:)\u0005\u0011<\u0007C\u0001.i\u0013\tI\u0007KA\u0003BMR,'\u000fC\u0003l\u0001\u0011\u0005q,A\u001buKN$8i\u001c:sK\u000e$h.Z:t\u001f\u001a$\u0015n\u001d;j]\u000e$xJ\u001c+va2,7oV5uQ.+\u0017PR5fY\u0012\u001cV\r\\3di>\u0014\bF\u00016n!\tQf.\u0003\u0002p!\n!A+Z:u\u0011\u0015\t\b\u0001\"\u0001`\u0003%#Xm\u001d;D_J\u0014Xm\u0019;oKN\u001cxJ\u001a#jgRLgn\u0019;P]R+\b\u000f\\3t/&$\bnS3z\r&,G\u000eZ*fY\u0016\u001cGo\u001c:O_R\fE\u000e\u001c$jK2$7oU3mK\u000e$X\r\u001a\u0015\u0003a6DQ\u0001\u001e\u0001\u0005\u0002}\u000b\u0011\u0007^3ti\u000e{'O]3di:,7o](g\t&\u001cH/\u001b8di>sG+\u001e9mKN<\u0016\u000e\u001e5LKf,\u0005\u0010\u001e:bGR|'\u000f\u000b\u0002t[\")q\u000f\u0001C\u0001?\u00061D/Z:u\u0007>\u0014(/Z2u]\u0016\u001c8o\u00144ESN$\u0018N\\2u\u001f:\u001cUo\u001d;p[RK\b/Z,ji\"$\u0016\u0010]3FqR\u0014\u0018m\u0019;pe\"\u0012a/\u001c\u0005\u0006u\u0002!\taX\u0001\"i\u0016\u001cHoQ8se\u0016\u001cGO\\3tg>3G)[:uS:\u001cGo\u00148UkBdWm\u001d\u0015\u0003s6DQ! \u0001\u0005\u0002}\u000bA\t^3ti\u000e{'O]3di:,7o](g\t&\u001cH/\u001b8di>s7)^:u_6$\u0016\u0010]3XSRDG+\u001e9mKJ+G/\u001e:oS:<G+\u001f9f\u000bb$(/Y2u_JD#\u0001`7\t\r\u0005\u0005\u0001\u0001\"\u0001`\u0003U\"Xm\u001d;D_J\u0014Xm\u0019;oKN\u001cxJ\u001a#jgRLgn\u0019;P]R+\b\u000f\\3t/&$\bNR5fY\u0012,\u0005\u0010\u001d:fgNLwN\\:)\u0005}l\u0007BBA\u0004\u0001\u0011\u0005q,\u0001\u0011uKN$8i\u001c:sK\u000e$h.Z:t\u001f\u001a$\u0015n\u001d;j]\u000e$xJ\u001c)pU>\u001c\bfAA\u0003[\"1\u0011Q\u0002\u0001\u0005\u0002}\u000b\u0011\u0005^3ti\u000e{'O]3di:,7o](g\t&\u001cH/\u001b8di>s\u0017\t^8nS\u000eD3!a\u0003n\u0011\u0019\t\u0019\u0002\u0001C\u0001?\u0006\u0011D/Z:u\u0007>\u0014(/Z2u]\u0016\u001c8o\u00144ESN$\u0018N\\2u\u001f:\fEo\\7jG^KG\u000f[*fY\u0016\u001cG/\u00117m\u0007\"\f'\u000fK\u0002\u0002\u00125Ds\u0001AA\r\u0003K\t9\u0003\u0005\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\ty\u0002U\u0001\u0007eVtg.\u001a:\n\t\u0005\r\u0012Q\u0004\u0002\b%Vtw+\u001b;i\u0003\u00151\u0018\r\\;fG\t\tI\u0003\u0005\u0003\u0002,\u0005ERBAA\u0017\u0015\r\ty\u0003U\u0001\beVtg.\u001a:t\u0013\u0011\t\u0019$!\f\u0003\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u0001")
public class DistinctITCase
extends MultipleProgramsTestBaseJUnit4 {
    private String resultPath = null;
    private String expected = null;
    private final TemporaryFolder _tempFolder = new TemporaryFolder();

    private String resultPath() {
        return this.resultPath;
    }

    private void resultPath_$eq(String x$1) {
        this.resultPath = x$1;
    }

    private String expected() {
        return this.expected;
    }

    private void expected_$eq(String x$1) {
        this.expected = x$1;
    }

    private TemporaryFolder _tempFolder() {
        return this._tempFolder;
    }

    @Rule
    public TemporaryFolder tempFolder() {
        return this._tempFolder();
    }

    @Before
    public void before() {
        this.resultPath_$eq(this.tempFolder().newFile().toURI().toString());
    }

    @After
    public void after() {
        TestBaseUtils.compareResultsByLinesInMemory((String)this.expected(), (String)this.resultPath());
    }

    @Test
    public void testCorrectnessOfDistinctOnTuplesWithKeyFieldSelector() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env);
        DataSet distinctDs = ds.union(ds).distinct((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        String x$6 = this.resultPath();
        FileSystem.WriteMode x$7 = FileSystem.WriteMode.OVERWRITE;
        String x$8 = distinctDs.writeAsCsv$default$2();
        String x$9 = distinctDs.writeAsCsv$default$3();
        distinctDs.writeAsCsv(x$6, x$8, x$9, x$7);
        env.execute();
        this.expected_$eq("1,1,Hi\n2,2,Hello\n3,2,Hello world\n");
    }

    @Test
    public void testCorrectnessOfDistinctOnTuplesWithKeyFieldSelectorNotAllFieldsSelected() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple5<Object, Object, Object, String, Object>> ds = CollectionDataSets$.MODULE$.getSmall5TupleDataSet(env);
        DataSet distinctDs = ds.union(ds).distinct((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)DistinctITCase.$anonfun$testCorrectnessOfDistinctOnTuplesWithKeyFieldSelectorNotAllFieldsSelected$1(x$1)), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE), ClassTag$.MODULE$.Int());
        distinctDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("1\n2\n");
    }

    @Test
    public void testCorrectnessOfDistinctOnTuplesWithKeyExtractor() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple5<Object, Object, Object, String, Object>> ds = CollectionDataSets$.MODULE$.getSmall5TupleDataSet(env);
        DataSet reduceDs = ds.union(ds).distinct((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)DistinctITCase.$anonfun$testCorrectnessOfDistinctOnTuplesWithKeyExtractor$1(x$2)), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE)).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)DistinctITCase.$anonfun$testCorrectnessOfDistinctOnTuplesWithKeyExtractor$2(x$3)), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE), ClassTag$.MODULE$.Int());
        reduceDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("1\n2\n");
    }

    @Test
    public void testCorrectnessOfDistinctOnCustomTypeWithTypeExtractor() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<CollectionDataSets.CustomType> ds = CollectionDataSets$.MODULE$.getCustomTypeDataSet(env);
        DataSet reduceDs = ds.distinct((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.myInt()), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE)).map((Function1 & Serializable & scala.Serializable)t -> new Tuple1.mcI.sp(t.myInt()), (TypeInformation)new CaseClassTypeInfo<Tuple1<Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple1<Object>> unused = new ScalaCaseClassSerializer<Tuple1<Object>>(this, fieldSerializers){

                    public Tuple1<Object> createInstance(Object[] fields) {
                        return new Tuple1.mcI.sp(BoxesRunTime.unboxToInt((Object)fields[0]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.api.scala.operators.DistinctITCase$$anon$5 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple1.class));
        String x$10 = this.resultPath();
        FileSystem.WriteMode x$11 = FileSystem.WriteMode.OVERWRITE;
        String x$12 = reduceDs.writeAsCsv$default$2();
        String x$13 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$10, x$12, x$13, x$11);
        env.execute();
        this.expected_$eq("1\n2\n3\n4\n5\n6\n");
    }

    @Test
    public void testCorrectnessOfDistinctOnTuples() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env);
        DataSet distinctDs = ds.union(ds).distinct();
        String x$14 = this.resultPath();
        FileSystem.WriteMode x$15 = FileSystem.WriteMode.OVERWRITE;
        String x$16 = distinctDs.writeAsCsv$default$2();
        String x$17 = distinctDs.writeAsCsv$default$3();
        distinctDs.writeAsCsv(x$14, x$16, x$17, x$15);
        env.execute();
        this.expected_$eq("1,1,Hi\n2,2,Hello\n3,2,Hello world\n");
    }

    @Test
    public void testCorrectnessOfDistinctOnCustomTypeWithTupleReturningTypeExtractor() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple5<Object, Object, Object, String, Object>> ds = CollectionDataSets$.MODULE$.get5TupleDataSet(env);
        DataSet reduceDs = ds.distinct((Function1 & Serializable & scala.Serializable)t -> new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)t._1()), BoxesRunTime.unboxToLong((Object)t._5())), (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.api.scala.operators.DistinctITCase$$anon$6 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).map((Function1 & Serializable & scala.Serializable)t -> new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)t._1()), BoxesRunTime.unboxToLong((Object)t._5())), (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.api.scala.operators.DistinctITCase$$anon$7 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        String x$18 = this.resultPath();
        FileSystem.WriteMode x$19 = FileSystem.WriteMode.OVERWRITE;
        String x$20 = reduceDs.writeAsCsv$default$2();
        String x$21 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$18, x$20, x$21, x$19);
        env.execute();
        this.expected_$eq("1,1\n2,1\n2,2\n3,2\n3,3\n4,1\n4,2\n5,1\n5,2\n5,3\n");
    }

    @Test
    public void testCorrectnessOfDistinctOnTuplesWithFieldExpressions() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple5<Object, Object, Object, String, Object>> ds = CollectionDataSets$.MODULE$.getSmall5TupleDataSet(env);
        DataSet reduceDs = ds.union(ds).distinct("_1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1 & Serializable & scala.Serializable)t -> new Tuple1.mcI.sp(BoxesRunTime.unboxToInt((Object)t._1())), (TypeInformation)new CaseClassTypeInfo<Tuple1<Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple1<Object>> unused = new ScalaCaseClassSerializer<Tuple1<Object>>(this, fieldSerializers){

                    public Tuple1<Object> createInstance(Object[] fields) {
                        return new Tuple1.mcI.sp(BoxesRunTime.unboxToInt((Object)fields[0]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.api.scala.operators.DistinctITCase$$anon$8 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple1.class));
        String x$22 = this.resultPath();
        FileSystem.WriteMode x$23 = FileSystem.WriteMode.OVERWRITE;
        String x$24 = reduceDs.writeAsCsv$default$2();
        String x$25 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$22, x$24, x$25, x$23);
        env.execute();
        this.expected_$eq("1\n2\n");
    }

    @Test
    public void testCorrectnessOfDistinctOnPojos() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<CollectionDataSets.POJO> ds = CollectionDataSets$.MODULE$.getDuplicatePojoDataSet(env);
        DataSet reduceDs = ds.distinct("nestedPojo.longNumber", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)DistinctITCase.$anonfun$testCorrectnessOfDistinctOnPojos$1(x$5)), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE), ClassTag$.MODULE$.Int());
        reduceDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("10000\n20000\n30000\n");
    }

    @Test
    public void testCorrectnessOfDistinctOnAtomic() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Object> ds = CollectionDataSets$.MODULE$.getIntDataSet(env);
        DataSet reduceDs = ds.distinct();
        reduceDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("1\n2\n3\n4\n5");
    }

    @Test
    public void testCorrectnessOfDistinctOnAtomicWithSelectAllChar() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<String> ds = CollectionDataSets$.MODULE$.getStringDataSet(env);
        DataSet reduceDs = ds.union(ds).distinct("_", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        reduceDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("I am fine.\nLuke Skywalker\nLOL\nHello world, how are you?\nHi\nHello world\nHello\nRandom comment\n");
    }

    public static final /* synthetic */ int $anonfun$testCorrectnessOfDistinctOnTuplesWithKeyFieldSelectorNotAllFieldsSelected$1(Tuple5 x$1) {
        return BoxesRunTime.unboxToInt((Object)x$1._1());
    }

    public static final /* synthetic */ int $anonfun$testCorrectnessOfDistinctOnTuplesWithKeyExtractor$1(Tuple5 x$2) {
        return BoxesRunTime.unboxToInt((Object)x$2._1());
    }

    public static final /* synthetic */ int $anonfun$testCorrectnessOfDistinctOnTuplesWithKeyExtractor$2(Tuple5 x$3) {
        return BoxesRunTime.unboxToInt((Object)x$3._1());
    }

    public static final /* synthetic */ int $anonfun$testCorrectnessOfDistinctOnPojos$1(CollectionDataSets.POJO x$5) {
        return (int)x$5.nestedPojo().longNumber();
    }

    public DistinctITCase(MultipleProgramsTestBaseJUnit4.TestExecutionMode mode) {
        super(mode);
    }
}

