/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.io;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.io.POJOItem;
import org.apache.flink.api.scala.io.ScalaCsvReaderWithPOJOITCase$;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.test.util.MultipleProgramsTestBaseJUnit4;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.util.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\u0001\u0003\u0001=\u0011AdU2bY\u0006\u001c5O\u001e*fC\u0012,'oV5uQB{%jT%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005\u0011\u0011n\u001c\u0006\u0003\u000b\u0019\tQa]2bY\u0006T!a\u0002\u0005\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E1R\"\u0001\n\u000b\u0005M!\u0012\u0001B;uS2T!!\u0006\u0005\u0002\tQ,7\u000f^\u0005\u0003/I\u0011a$T;mi&\u0004H.\u001a)s_\u001e\u0014\u0018-\\:UKN$()Y:f\u0015Vs\u0017\u000e\u001e\u001b\t\u0011e\u0001!\u0011!Q\u0001\ni\tA!\\8eKB\u00111D\b\b\u0003#qI!!\b\n\u0002=5+H\u000e^5qY\u0016\u0004&o\\4sC6\u001cH+Z:u\u0005\u0006\u001cXMS+oSR$\u0014BA\u0010!\u0005E!Vm\u001d;Fq\u0016\u001cW\u000f^5p]6{G-\u001a\u0006\u0003;IAQA\t\u0001\u0005\u0002\r\na\u0001P5oSRtDC\u0001\u0013'!\t)\u0003!D\u0001\u0003\u0011\u0015I\u0012\u00051\u0001\u001b\u0011\u001dA\u0003A1A\u0005\n%\n1b\u0018;f[B4u\u000e\u001c3feV\t!\u0006\u0005\u0002,a5\tAF\u0003\u0002.]\u0005)!/\u001e7fg*\u0011q\u0006D\u0001\u0006UVt\u0017\u000e^\u0005\u0003c1\u0012q\u0002V3na>\u0014\u0018M]=G_2$WM\u001d\u0005\u0007g\u0001\u0001\u000b\u0011\u0002\u0016\u0002\u0019}#X-\u001c9G_2$WM\u001d\u0011\t\u000fU\u0002\u0001\u0019!C\u0005m\u0005Q!/Z:vYR\u0004\u0016\r\u001e5\u0016\u0003]\u0002\"\u0001\u000f!\u000f\u0005er\u0004C\u0001\u001e>\u001b\u0005Y$B\u0001\u001f\u000f\u0003\u0019a$o\\8u})\tQ!\u0003\u0002@{\u00051\u0001K]3eK\u001aL!!\u0011\"\u0003\rM#(/\u001b8h\u0015\tyT\bC\u0004E\u0001\u0001\u0007I\u0011B#\u0002\u001dI,7/\u001e7u!\u0006$\bn\u0018\u0013fcR\u0011aI\u0013\t\u0003\u000f\"k\u0011!P\u0005\u0003\u0013v\u0012A!\u00168ji\"91jQA\u0001\u0002\u00049\u0014a\u0001=%c!1Q\n\u0001Q!\n]\n1B]3tk2$\b+\u0019;iA!9q\n\u0001a\u0001\n\u00131\u0014\u0001C3ya\u0016\u001cG/\u001a3\t\u000fE\u0003\u0001\u0019!C\u0005%\u0006aQ\r\u001f9fGR,Gm\u0018\u0013fcR\u0011ai\u0015\u0005\b\u0017B\u000b\t\u00111\u00018\u0011\u0019)\u0006\u0001)Q\u0005o\u0005IQ\r\u001f9fGR,G\r\t\u0005\u0006/\u0002!\t!K\u0001\u000bi\u0016l\u0007OR8mI\u0016\u0014\bF\u0001,Z!\tQ6,D\u0001/\u0013\tafF\u0001\u0003Sk2,\u0007\"\u00020\u0001\t\u0003y\u0016A\u00022fM>\u0014X\rF\u0001GQ\ti\u0016\r\u0005\u0002[E&\u00111M\f\u0002\u0007\u0005\u00164wN]3\t\u000b\u0015\u0004A\u0011A0\u0002\u000b\u00054G/\u001a:)\u0005\u0011<\u0007C\u0001.i\u0013\tIgFA\u0003BMR,'\u000fC\u0003l\u0001\u0011\u0005A.A\bde\u0016\fG/Z%oaV$H)\u0019;b)\t9T\u000eC\u0003oU\u0002\u0007q'\u0001\u0003eCR\f\u0007\"\u00029\u0001\t\u0003y\u0016\u0001\u0004;fgR\u0004vJS(UsB,\u0007FA8s!\tQ6/\u0003\u0002u]\t!A+Z:u\u0011\u00151\b\u0001\"\u0001`\u0003m!Xm\u001d;Q\u001f*{E+\u001f9f/&$\bNR5fY\u0012\u001cxJ\u001d3fe\"\u0012QO\u001d\u0005\u0006s\u0002!\taX\u0001\u001fi\u0016\u001cH\u000fU(K\u001fRK\b/Z,ji\"|W\u000f\u001e$jK2$7o\u0014:eKJD#\u0001\u001f:\t\u000bq\u0004A\u0011A0\u0002[Q,7\u000f\u001e)P\u0015>#\u0016\u0010]3XSRDg)[3mIN|%\u000fZ3s\u0003:$g)[3mIN\u001cV\r\\3di&|g\u000e\u000b\u0002|e\"2\u0001a`A\u0006\u0003\u001b\u0001B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000bq\u0013A\u0002:v]:,'/\u0003\u0003\u0002\n\u0005\r!a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u0003\u0003\u001f\u0001B!!\u0005\u0002\u00185\u0011\u00111\u0003\u0006\u0004\u0003+q\u0013a\u0002:v]:,'o]\u0005\u0005\u00033\t\u0019BA\u0007QCJ\fW.\u001a;fe&TX\r\u001a")
public class ScalaCsvReaderWithPOJOITCase
extends MultipleProgramsTestBaseJUnit4 {
    private final TemporaryFolder _tempFolder = new TemporaryFolder();
    private String resultPath = null;
    private String expected = null;

    private TemporaryFolder _tempFolder() {
        return this._tempFolder;
    }

    private String resultPath() {
        return this.resultPath;
    }

    private void resultPath_$eq(String x$1) {
        this.resultPath = x$1;
    }

    private String expected() {
        return this.expected;
    }

    private void expected_$eq(String x$1) {
        this.expected = x$1;
    }

    @Rule
    public TemporaryFolder tempFolder() {
        return this._tempFolder();
    }

    @Before
    public void before() {
        this.resultPath_$eq(this.tempFolder().newFile("result").toURI().toString());
    }

    @After
    public void after() {
        TestBaseUtils.compareResultsByLinesInMemory((String)this.expected(), (String)this.resultPath());
    }

    public String createInputData(String data) {
        File dataFile = this.tempFolder().newFile("data");
        FileUtils.writeFileUtf8((File)dataFile, (String)data);
        return dataFile.toURI().toString();
    }

    @Test
    public void testPOJOType() {
        GenericTypeInfo genericTypeInfo;
        Class<POJOItem> clazz;
        String dataPath = this.createInputData("ABC,2.20,3\nDEF,5.1,5\nDEF,3.30,1\nGHI,3.30,10");
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        String x$1 = dataPath;
        String[] x$2 = (String[])((Object[])new String[]{"f1", "f2", "f3"});
        String x$3 = env.readCsvFile$default$2();
        String x$4 = env.readCsvFile$default$3();
        Character x$5 = env.readCsvFile$default$4();
        boolean x$6 = env.readCsvFile$default$5();
        String x$7 = env.readCsvFile$default$6();
        boolean x$8 = env.readCsvFile$default$7();
        int[] x$9 = env.readCsvFile$default$8();
        ClassTag classTag = ClassTag$.MODULE$.apply(POJOItem.class);
        .colon.colon fields = new .colon.colon((Object)new Tuple2((Object)"f3", (Object)BasicTypeInfo.getInfoFor(Integer.TYPE)), (List)new .colon.colon((Object)new Tuple2((Object)"f2", (Object)BasicTypeInfo.getInfoFor(Double.TYPE)), (List)new .colon.colon((Object)new Tuple2((Object)"f1", (Object)BasicTypeInfo.getInfoFor(String.class)), (List)Nil$.MODULE$)));
        Map clazzFields = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef error = BooleanRef.create((boolean)false);
        for (Class traversalClazz = clazz = POJOItem.class; traversalClazz != null; traversalClazz = traversalClazz.getSuperclass()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])traversalClazz.getDeclaredFields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
                block0: {
                    if (!clazzFields.contains((Object)field.getName()) || Modifier.isStatic(field.getModifiers())) break block0;
                    Predef$.MODULE$.println((Object)new StringBuilder(59).append("The field ").append(field).append(" is already contained in the ").append(new StringBuilder(66).append("hierarchy of the class ").append(clazz).append(". Please use unique field names throughout ").toString()).append("your class hierarchy").toString());
                    error$1.elem = true;
                }
                return (Map)clazzFields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), field));
            });
        }
        if (error.elem) {
            genericTypeInfo = new GenericTypeInfo(clazz);
        } else {
            List pojoFields = (List)fields.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String fName = (String)tuple2._1();
                BasicTypeInfo fTpe = (BasicTypeInfo)tuple2._2();
                Field field = (Field)clazzFields.apply((Object)fName);
                Iterable iterable = Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)new PojoField((Field)clazzFields.apply((Object)fName), (TypeInformation)fTpe)));
                return iterable;
            }, List$.MODULE$.canBuildFrom());
            genericTypeInfo = new PojoTypeInfo(clazz, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pojoFields).asJava());
        }
        DataSet data = env.readCsvFile(x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$2, classTag, (TypeInformation)genericTypeInfo);
        CaseClassTypeInfo<Tuple2<String, Object>> typeInfo = new CaseClassTypeInfo<Tuple2<String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<String, Object>> unused = new ScalaCaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.api.scala.io.ScalaCsvReaderWithPOJOITCase$$anon$4 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        };
        data.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("ABC,2.20,3\nDEF,5.10,5\nDEF,3.30,1\nGHI,3.30,10");
    }

    @Test
    public void testPOJOTypeWithFieldsOrder() {
        GenericTypeInfo genericTypeInfo;
        Class<POJOItem> clazz;
        String dataPath = this.createInputData("2.20,ABC,3\n5.1,DEF,5\n3.30,DEF,1\n3.30,GHI,10");
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        String x$10 = dataPath;
        String[] x$11 = (String[])((Object[])new String[]{"f2", "f1", "f3"});
        String x$12 = env.readCsvFile$default$2();
        String x$13 = env.readCsvFile$default$3();
        Character x$14 = env.readCsvFile$default$4();
        boolean x$15 = env.readCsvFile$default$5();
        String x$16 = env.readCsvFile$default$6();
        boolean x$17 = env.readCsvFile$default$7();
        int[] x$18 = env.readCsvFile$default$8();
        ClassTag classTag = ClassTag$.MODULE$.apply(POJOItem.class);
        .colon.colon fields = new .colon.colon((Object)new Tuple2((Object)"f3", (Object)BasicTypeInfo.getInfoFor(Integer.TYPE)), (List)new .colon.colon((Object)new Tuple2((Object)"f2", (Object)BasicTypeInfo.getInfoFor(Double.TYPE)), (List)new .colon.colon((Object)new Tuple2((Object)"f1", (Object)BasicTypeInfo.getInfoFor(String.class)), (List)Nil$.MODULE$)));
        Map clazzFields = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef error = BooleanRef.create((boolean)false);
        for (Class traversalClazz = clazz = POJOItem.class; traversalClazz != null; traversalClazz = traversalClazz.getSuperclass()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])traversalClazz.getDeclaredFields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
                block0: {
                    if (!clazzFields.contains((Object)field.getName()) || Modifier.isStatic(field.getModifiers())) break block0;
                    Predef$.MODULE$.println((Object)new StringBuilder(59).append("The field ").append(field).append(" is already contained in the ").append(new StringBuilder(66).append("hierarchy of the class ").append(clazz).append(". Please use unique field names throughout ").toString()).append("your class hierarchy").toString());
                    error$2.elem = true;
                }
                return (Map)clazzFields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), field));
            });
        }
        if (error.elem) {
            genericTypeInfo = new GenericTypeInfo(clazz);
        } else {
            List pojoFields = (List)fields.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String fName = (String)tuple2._1();
                BasicTypeInfo fTpe = (BasicTypeInfo)tuple2._2();
                Field field = (Field)clazzFields.apply((Object)fName);
                Iterable iterable = Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)new PojoField((Field)clazzFields.apply((Object)fName), (TypeInformation)fTpe)));
                return iterable;
            }, List$.MODULE$.canBuildFrom());
            genericTypeInfo = new PojoTypeInfo(clazz, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pojoFields).asJava());
        }
        DataSet data = env.readCsvFile(x$10, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$11, classTag, (TypeInformation)genericTypeInfo);
        CaseClassTypeInfo<Tuple2<String, Object>> typeInfo = new CaseClassTypeInfo<Tuple2<String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<String, Object>> unused = new ScalaCaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.api.scala.io.ScalaCsvReaderWithPOJOITCase$$anon$5 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        };
        data.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("ABC,2.20,3\nDEF,5.10,5\nDEF,3.30,1\nGHI,3.30,10");
    }

    @Test
    public void testPOJOTypeWithoutFieldsOrder() {
        String dataPath = this.createInputData("");
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        try {
            GenericTypeInfo genericTypeInfo;
            Class<POJOItem> clazz;
            String string = env.readCsvFile$default$2();
            String string2 = env.readCsvFile$default$3();
            Character c = env.readCsvFile$default$4();
            boolean bl = env.readCsvFile$default$5();
            String string3 = env.readCsvFile$default$6();
            boolean bl2 = env.readCsvFile$default$7();
            int[] nArray = env.readCsvFile$default$8();
            String[] stringArray = env.readCsvFile$default$9();
            ClassTag classTag = ClassTag$.MODULE$.apply(POJOItem.class);
            .colon.colon fields = new .colon.colon((Object)new Tuple2((Object)"f3", (Object)BasicTypeInfo.getInfoFor(Integer.TYPE)), (List)new .colon.colon((Object)new Tuple2((Object)"f2", (Object)BasicTypeInfo.getInfoFor(Double.TYPE)), (List)new .colon.colon((Object)new Tuple2((Object)"f1", (Object)BasicTypeInfo.getInfoFor(String.class)), (List)Nil$.MODULE$)));
            Map clazzFields = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            BooleanRef error = BooleanRef.create((boolean)false);
            for (Class traversalClazz = clazz = POJOItem.class; traversalClazz != null; traversalClazz = traversalClazz.getSuperclass()) {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])traversalClazz.getDeclaredFields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
                    block0: {
                        if (!clazzFields.contains((Object)field.getName()) || Modifier.isStatic(field.getModifiers())) break block0;
                        Predef$.MODULE$.println((Object)new StringBuilder(59).append("The field ").append(field).append(" is already contained in the ").append(new StringBuilder(66).append("hierarchy of the class ").append(clazz).append(". Please use unique field names throughout ").toString()).append("your class hierarchy").toString());
                        error$3.elem = true;
                    }
                    return (Map)clazzFields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), field));
                });
            }
            if (error.elem) {
                genericTypeInfo = new GenericTypeInfo(clazz);
            } else {
                List pojoFields = (List)fields.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String fName = (String)tuple2._1();
                    BasicTypeInfo fTpe = (BasicTypeInfo)tuple2._2();
                    Field field = (Field)clazzFields.apply((Object)fName);
                    Iterable iterable = Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)new PojoField((Field)clazzFields.apply((Object)fName), (TypeInformation)fTpe)));
                    return iterable;
                }, List$.MODULE$.canBuildFrom());
                genericTypeInfo = new PojoTypeInfo(clazz, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pojoFields).asJava());
            }
            DataSet data = env.readCsvFile(dataPath, string, string2, c, bl, string3, bl2, nArray, stringArray, classTag, (TypeInformation)genericTypeInfo);
            Assert.fail((String)"POJO type without fields order must raise IllegalArgumentException!");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.expected_$eq("");
        this.resultPath_$eq(dataPath);
    }

    @Test
    public void testPOJOTypeWithFieldsOrderAndFieldsSelection() {
        GenericTypeInfo genericTypeInfo;
        Class<POJOItem> clazz;
        String dataPath = this.createInputData("2.20,3,ABC\n5.1,5,DEF\n3.30,1,DEF\n3.30,10,GHI");
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        String x$19 = dataPath;
        int[] x$20 = new int[]{1, 2};
        String[] x$21 = (String[])((Object[])new String[]{"f3", "f1"});
        String x$22 = env.readCsvFile$default$2();
        String x$23 = env.readCsvFile$default$3();
        Character x$24 = env.readCsvFile$default$4();
        boolean x$25 = env.readCsvFile$default$5();
        String x$26 = env.readCsvFile$default$6();
        boolean x$27 = env.readCsvFile$default$7();
        ClassTag classTag = ClassTag$.MODULE$.apply(POJOItem.class);
        .colon.colon fields = new .colon.colon((Object)new Tuple2((Object)"f3", (Object)BasicTypeInfo.getInfoFor(Integer.TYPE)), (List)new .colon.colon((Object)new Tuple2((Object)"f2", (Object)BasicTypeInfo.getInfoFor(Double.TYPE)), (List)new .colon.colon((Object)new Tuple2((Object)"f1", (Object)BasicTypeInfo.getInfoFor(String.class)), (List)Nil$.MODULE$)));
        Map clazzFields = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef error = BooleanRef.create((boolean)false);
        for (Class traversalClazz = clazz = POJOItem.class; traversalClazz != null; traversalClazz = traversalClazz.getSuperclass()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])traversalClazz.getDeclaredFields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
                block0: {
                    if (!clazzFields.contains((Object)field.getName()) || Modifier.isStatic(field.getModifiers())) break block0;
                    Predef$.MODULE$.println((Object)new StringBuilder(59).append("The field ").append(field).append(" is already contained in the ").append(new StringBuilder(66).append("hierarchy of the class ").append(clazz).append(". Please use unique field names throughout ").toString()).append("your class hierarchy").toString());
                    error$4.elem = true;
                }
                return (Map)clazzFields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), field));
            });
        }
        if (error.elem) {
            genericTypeInfo = new GenericTypeInfo(clazz);
        } else {
            List pojoFields = (List)fields.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String fName = (String)tuple2._1();
                BasicTypeInfo fTpe = (BasicTypeInfo)tuple2._2();
                Field field = (Field)clazzFields.apply((Object)fName);
                Iterable iterable = Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)new PojoField((Field)clazzFields.apply((Object)fName), (TypeInformation)fTpe)));
                return iterable;
            }, List$.MODULE$.canBuildFrom());
            genericTypeInfo = new PojoTypeInfo(clazz, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pojoFields).asJava());
        }
        DataSet data = env.readCsvFile(x$19, x$22, x$23, x$24, x$25, x$26, x$27, x$20, x$21, classTag, (TypeInformation)genericTypeInfo);
        CaseClassTypeInfo<Tuple2<String, Object>> typeInfo = new CaseClassTypeInfo<Tuple2<String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<String, Object>> unused = new ScalaCaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.api.scala.io.ScalaCsvReaderWithPOJOITCase$$anon$6 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        };
        data.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("ABC,0.00,3\nDEF,0.00,5\nDEF,0.00,1\nGHI,0.00,10");
    }

    public ScalaCsvReaderWithPOJOITCase(MultipleProgramsTestBaseJUnit4.TestExecutionMode mode) {
        super(mode);
    }
}

