/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.functions;

import org.apache.flink.api.scala.functions.TestClass;
import org.apache.flink.api.scala.functions.TestClassWithNesting;
import org.apache.flink.api.scala.functions.TestClassWithoutDefaultConstructor;
import org.apache.flink.api.scala.functions.TestClassWithoutFieldAccess;
import org.apache.flink.api.scala.functions.TestObject$;
import org.apache.flink.api.scala.functions.TestObjectWithBogusReturns$;
import org.apache.flink.api.scala.functions.TestObjectWithNestedReturns$;
import org.apache.flink.api.scala.functions.TestObjectWithNesting$;
import org.apache.flink.test.util.MultipleProgramsTestBaseJUnit4;
import org.apache.flink.test.util.TestBaseUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.reflect.ScalaSignature;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u0001\u0003\u0001=\u0011Ac\u00117pgV\u0014Xm\u00117fC:,'/\u0013+DCN,'BA\u0002\u0005\u0003%1WO\\2uS>t7O\u0003\u0002\u0006\r\u0005)1oY1mC*\u0011q\u0001C\u0001\u0004CBL'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Yi\u0011A\u0005\u0006\u0003'Q\tA!\u001e;jY*\u0011Q\u0003C\u0001\u0005i\u0016\u001cH/\u0003\u0002\u0018%\tqR*\u001e7uSBdW\r\u0015:pOJ\fWn\u001d+fgR\u0014\u0015m]3K+:LG\u000f\u000e\u0005\t3\u0001\u0011\t\u0011)A\u00055\u0005!Qn\u001c3f!\tYbD\u0004\u0002\u00129%\u0011QDE\u0001\u001f\u001bVdG/\u001b9mKB\u0013xn\u001a:b[N$Vm\u001d;CCN,'*\u00168jiRJ!a\b\u0011\u0003#Q+7\u000f^#yK\u000e,H/[8o\u001b>$WM\u0003\u0002\u001e%!)!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"\"\u0001\n\u0014\u0011\u0005\u0015\u0002Q\"\u0001\u0002\t\u000be\t\u0003\u0019\u0001\u000e\t\u000f!\u0002!\u0019!C\u0001S\u0005Yq\f^3na\u001a{G\u000eZ3s+\u0005Q\u0003CA\u00161\u001b\u0005a#BA\u0017/\u0003\u0015\u0011X\u000f\\3t\u0015\tyC\"A\u0003kk:LG/\u0003\u00022Y\tyA+Z7q_J\f'/\u001f$pY\u0012,'\u000f\u0003\u00044\u0001\u0001\u0006IAK\u0001\r?R,W\u000e\u001d$pY\u0012,'\u000f\t\u0005\nk\u0001\u0001\r\u00111A\u0005\u0002Y\n!B]3tk2$\b+\u0019;i+\u00059\u0004C\u0001\u001dA\u001d\tId\b\u0005\u0002;{5\t1H\u0003\u0002=\u001d\u00051AH]8pizR\u0011!B\u0005\u0003\u007fu\na\u0001\u0015:fI\u00164\u0017BA!C\u0005\u0019\u0019FO]5oO*\u0011q(\u0010\u0005\n\t\u0002\u0001\r\u00111A\u0005\u0002\u0015\u000baB]3tk2$\b+\u0019;i?\u0012*\u0017\u000f\u0006\u0002G\u0015B\u0011q\tS\u0007\u0002{%\u0011\u0011*\u0010\u0002\u0005+:LG\u000fC\u0004L\u0007\u0006\u0005\t\u0019A\u001c\u0002\u0007a$\u0013\u0007C\u0005N\u0001\u0001\u0007\t\u0011)Q\u0005o\u0005Y!/Z:vYR\u0004\u0016\r\u001e5!\u0011%y\u0005\u00011AA\u0002\u0013\u0005a'\u0001\u0004sKN,H\u000e\u001e\u0005\n#\u0002\u0001\r\u00111A\u0005\u0002I\u000b!B]3tk2$x\fJ3r)\t15\u000bC\u0004L!\u0006\u0005\t\u0019A\u001c\t\u0013U\u0003\u0001\u0019!A!B\u00139\u0014a\u0002:fgVdG\u000f\t\u0005\u0006/\u0002!\t!K\u0001\u000bi\u0016l\u0007OR8mI\u0016\u0014\bF\u0001,Z!\tQ6,D\u0001/\u0013\tafF\u0001\u0003Sk2,\u0007\"\u00020\u0001\t\u0003y\u0016A\u00022fM>\u0014X\rF\u0001GQ\ti\u0016\r\u0005\u0002[E&\u00111M\f\u0002\u0007\u0005\u00164wN]3\t\u000b\u0015\u0004A\u0011A0\u0002\u000b\u00054G/\u001a:)\u0005\u0011<\u0007C\u0001.i\u0013\tIgFA\u0003BMR,'\u000fC\u0003l\u0001\u0011\u0005q,\u0001\u0006uKN$xJ\u00196fGRD#A[7\u0011\u0005is\u0017BA8/\u0005\u0011!Vm\u001d;\t\u000bE\u0004A\u0011A0\u0002\u0013Q,7\u000f^\"mCN\u001c\bF\u00019n\u0011\u0015!\b\u0001\"\u0001`\u0003\u0005\"Xm\u001d;DY\u0006\u001c8oV5uQ>,H\u000fR3gCVd7i\u001c8tiJ,8\r^8sQ\t\u0019X\u000eC\u0003x\u0001\u0011\u0005q,A\u000euKN$8\t\\1tg^KG\u000f[8vi\u001aKW\r\u001c3BG\u000e,7o\u001d\u0015\u0003m6DQA\u001f\u0001\u0005\u0002}\u000bQ\u0003^3ti>\u0013'.Z2u/&$\bNT3ti&tw\r\u000b\u0002z[\")Q\u0010\u0001C\u0001?\u0006!B/Z:u\u00072\f7o],ji\"tUm\u001d;j]\u001eD#\u0001`7\t\r\u0005\u0005\u0001\u0001\"\u0001`\u0003i!Xm\u001d;PE*,7\r^,ji\"\u0014unZ;t%\u0016$XO\u001d8tQ\tyX\u000e\u0003\u0004\u0002\b\u0001!\taX\u0001\u001ci\u0016\u001cHo\u00142kK\u000e$x+\u001b;i\u001d\u0016\u001cH/\u001a3SKR,(O\\:)\u0007\u0005\u0015Q\u000eK\u0004\u0001\u0003\u001b\tI\"a\u0007\u0011\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u0005/\u0003\u0019\u0011XO\u001c8fe&!\u0011qCA\t\u0005\u001d\u0011VO\\,ji\"\fQA^1mk\u0016\u001c#!!\b\u0011\t\u0005}\u0011QE\u0007\u0003\u0003CQ1!a\t/\u0003\u001d\u0011XO\u001c8feNLA!a\n\u0002\"\ti\u0001+\u0019:b[\u0016$XM]5{K\u0012\u0004")
public class ClosureCleanerITCase
extends MultipleProgramsTestBaseJUnit4 {
    private final TemporaryFolder _tempFolder = new TemporaryFolder();
    private String resultPath;
    private String result;

    public TemporaryFolder _tempFolder() {
        return this._tempFolder;
    }

    public String resultPath() {
        return this.resultPath;
    }

    public void resultPath_$eq(String x$1) {
        this.resultPath = x$1;
    }

    public String result() {
        return this.result;
    }

    public void result_$eq(String x$1) {
        this.result = x$1;
    }

    @Rule
    public TemporaryFolder tempFolder() {
        return this._tempFolder();
    }

    @Before
    public void before() {
        this.resultPath_$eq(this.tempFolder().newFile().toURI().toString());
    }

    @After
    public void after() {
        TestBaseUtils.compareResultsByLinesInMemory((String)this.result(), (String)this.resultPath());
    }

    @Test
    public void testObject() {
        TestObject$.MODULE$.run(this.resultPath());
        this.result_$eq("30");
    }

    @Test
    public void testClass() {
        TestClass obj = new TestClass();
        obj.run(this.resultPath());
        this.result_$eq("30");
    }

    @Test
    public void testClassWithoutDefaulConstructor() {
        TestClassWithoutDefaultConstructor obj = new TestClassWithoutDefaultConstructor(5);
        obj.run(this.resultPath());
        this.result_$eq("30");
    }

    @Test
    public void testClassWithoutFieldAccess() {
        TestClassWithoutFieldAccess obj = new TestClassWithoutFieldAccess();
        obj.run(this.resultPath());
        this.result_$eq("30");
    }

    @Test
    public void testObjectWithNesting() {
        TestObjectWithNesting$.MODULE$.run(this.resultPath());
        this.result_$eq("27");
    }

    @Test
    public void testClassWithNesting() {
        TestClassWithNesting obj = new TestClassWithNesting(1);
        obj.run(this.resultPath());
        this.result_$eq("27");
    }

    @Test
    public void testObjectWithBogusReturns() {
        TestObjectWithBogusReturns$.MODULE$.run(this.resultPath());
        this.result_$eq("1");
    }

    @Test
    public void testObjectWithNestedReturns() {
        TestObjectWithNestedReturns$.MODULE$.run(this.resultPath());
        this.result_$eq("1");
    }

    public ClosureCleanerITCase(MultipleProgramsTestBaseJUnit4.TestExecutionMode mode) {
        super(mode);
    }
}

