/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.streaming.runtime;

import java.util.ArrayList;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.testutils.junit.SharedObjects;
import org.apache.flink.testutils.junit.SharedReference;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class BufferTimeoutITCase
extends AbstractTestBase {
    @Rule
    public final SharedObjects sharedObjects = SharedObjects.create();

    @Test
    public void testDisablingBufferTimeout() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(1);
        env.setBufferTimeout(-1L);
        final SharedReference results = this.sharedObjects.add(new ArrayList());
        env.addSource((SourceFunction)new SourceFunction<Integer>(){

            public void run(SourceFunction.SourceContext<Integer> ctx) throws Exception {
                ctx.collect((Object)1);
                Thread.sleep(Long.MAX_VALUE);
            }

            public void cancel() {
            }
        }).slotSharingGroup("source").addSink((SinkFunction)new SinkFunction<Integer>(){

            public void invoke(Integer value, SinkFunction.Context context) {
                ((ArrayList)results.get()).add(value);
            }
        }).slotSharingGroup("sink");
        JobClient jobClient = env.executeAsync();
        CommonTestUtils.waitForAllTaskRunning((MiniCluster)MINI_CLUSTER_RESOURCE.getMiniCluster(), (JobID)jobClient.getJobID(), (boolean)false);
        Assert.assertTrue((String)"OutputFlusher thread is unexpectedly running", (boolean)Thread.getAllStackTraces().keySet().stream().noneMatch(thread -> thread.getName().startsWith("OutputFlusher")));
    }
}

