/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.summarize.BooleanColumnSummary;
import org.apache.flink.api.java.summarize.NumericColumnSummary;
import org.apache.flink.api.java.summarize.StringColumnSummary;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple8;
import org.apache.flink.api.java.utils.DataSetUtils;
import org.apache.flink.test.operators.util.CollectionDataSets;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.apache.flink.types.DoubleValue;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DataSetUtilsITCase
extends MultipleProgramsTestBase {
    public DataSetUtilsITCase(MultipleProgramsTestBase.TestExecutionMode mode) {
        super(mode);
    }

    @Test
    public void testCountElementsPerPartition() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        long expectedSize = 100L;
        DataSource numbers = env.generateSequence(0L, expectedSize - 1L);
        DataSet ds = DataSetUtils.countElementsPerPartition((DataSet)numbers);
        Assert.assertEquals((long)env.getParallelism(), (long)ds.count());
        Assert.assertEquals((long)expectedSize, (long)((Long)((Tuple2)ds.sum((int)1).collect().get((int)0)).f1));
    }

    @Test
    public void testZipWithIndex() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        long expectedSize = 100L;
        DataSource numbers = env.generateSequence(0L, expectedSize - 1L);
        ArrayList result = new ArrayList(DataSetUtils.zipWithIndex((DataSet)numbers).collect());
        Assert.assertEquals((long)expectedSize, (long)result.size());
        Collections.sort(result, new Comparator<Tuple2<Long, Long>>(){

            @Override
            public int compare(Tuple2<Long, Long> o1, Tuple2<Long, Long> o2) {
                return ((Long)o1.f0).compareTo((Long)o2.f0);
            }
        });
        int i = 0;
        while ((long)i < expectedSize) {
            Assert.assertEquals((long)i, (long)((Long)((Tuple2)result.get((int)i)).f0));
            ++i;
        }
    }

    @Test
    public void testZipWithUniqueId() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        long expectedSize = 100L;
        DataSource numbers = env.generateSequence(1L, expectedSize);
        MapOperator ids = DataSetUtils.zipWithUniqueId((DataSet)numbers).map((MapFunction)new MapFunction<Tuple2<Long, Long>, Long>(){

            public Long map(Tuple2<Long, Long> value) throws Exception {
                return (Long)value.f0;
            }
        });
        HashSet result = new HashSet(ids.collect());
        Assert.assertEquals((long)expectedSize, (long)result.size());
    }

    @Test
    public void testIntegerDataSetChecksumHashCode() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Integer> ds = CollectionDataSets.getIntegerDataSet(env);
        Utils.ChecksumHashCode checksum = DataSetUtils.checksumHashCode(ds);
        Assert.assertEquals((long)checksum.getCount(), (long)15L);
        Assert.assertEquals((long)checksum.getChecksum(), (long)55L);
    }

    @Test
    public void testSummarize() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        ArrayList<Tuple8> data = new ArrayList<Tuple8>();
        data.add(new Tuple8((Object)1, (Object)1, (Object)100L, (Object)Float.valueOf(0.1f), (Object)1.012376, (Object)"hello", (Object)false, (Object)new DoubleValue(50.0)));
        data.add(new Tuple8((Object)2, (Object)2, (Object)1000L, (Object)Float.valueOf(0.2f), (Object)2.003453, (Object)"hello", (Object)true, (Object)new DoubleValue(50.0)));
        data.add(new Tuple8((Object)4, (Object)10, (Object)10000L, (Object)Float.valueOf(0.2f), (Object)75.00005, (Object)"null", (Object)true, (Object)new DoubleValue(50.0)));
        data.add(new Tuple8((Object)10, (Object)4, (Object)100L, (Object)Float.valueOf(0.9f), (Object)79.5, (Object)"", (Object)true, (Object)new DoubleValue(50.0)));
        data.add(new Tuple8((Object)5, (Object)5, (Object)1000L, (Object)Float.valueOf(0.2f), (Object)10.0000001, (Object)"a", (Object)false, (Object)new DoubleValue(50.0)));
        data.add(new Tuple8((Object)6, (Object)6, (Object)10L, (Object)Float.valueOf(0.1f), (Object)2.3E-12, (Object)"", (Object)true, (Object)new DoubleValue(100.0)));
        data.add(new Tuple8((Object)7, (Object)7, (Object)1L, (Object)Float.valueOf(0.2f), (Object)Double.POSITIVE_INFINITY, (Object)"abcdefghijklmnop", (Object)true, (Object)new DoubleValue(100.0)));
        data.add(new Tuple8((Object)8, (Object)8, (Object)-100L, (Object)Float.valueOf(0.001f), (Object)Double.NaN, (Object)"abcdefghi", (Object)true, (Object)new DoubleValue(100.0)));
        Collections.shuffle(data);
        DataSource ds = env.fromCollection(data);
        Tuple results = DataSetUtils.summarize((DataSet)ds);
        Assert.assertEquals((long)8L, (long)results.getArity());
        NumericColumnSummary col0Summary = (NumericColumnSummary)results.getField(0);
        Assert.assertEquals((long)8L, (long)col0Summary.getNonMissingCount());
        Assert.assertEquals((long)1L, (long)((Short)col0Summary.getMin()).shortValue());
        Assert.assertEquals((long)10L, (long)((Short)col0Summary.getMax()).shortValue());
        Assert.assertEquals((double)5.375, (double)col0Summary.getMean(), (double)0.0);
        NumericColumnSummary col1Summary = (NumericColumnSummary)results.getField(1);
        Assert.assertEquals((long)1L, (long)((Integer)col1Summary.getMin()).intValue());
        Assert.assertEquals((long)10L, (long)((Integer)col1Summary.getMax()).intValue());
        Assert.assertEquals((double)5.375, (double)col1Summary.getMean(), (double)0.0);
        NumericColumnSummary col2Summary = (NumericColumnSummary)results.getField(2);
        Assert.assertEquals((long)-100L, (long)((Long)col2Summary.getMin()));
        Assert.assertEquals((long)10000L, (long)((Long)col2Summary.getMax()));
        NumericColumnSummary col3Summary = (NumericColumnSummary)results.getField(3);
        Assert.assertEquals((long)8L, (long)col3Summary.getTotalCount());
        Assert.assertEquals((double)0.001, (double)((Float)col3Summary.getMin()).doubleValue(), (double)1.0E-7);
        Assert.assertEquals((double)0.89999999, (double)((Float)col3Summary.getMax()).doubleValue(), (double)1.0E-7);
        Assert.assertEquals((double)0.2376249988883501, (double)col3Summary.getMean(), (double)1.0E-12);
        Assert.assertEquals((double)0.0768965488108089, (double)col3Summary.getVariance(), (double)1.0E-8);
        Assert.assertEquals((double)0.27730226975415995, (double)col3Summary.getStandardDeviation(), (double)1.0E-12);
        NumericColumnSummary col4Summary = (NumericColumnSummary)results.getField(4);
        Assert.assertEquals((long)6L, (long)col4Summary.getNonMissingCount());
        Assert.assertEquals((long)2L, (long)col4Summary.getMissingCount());
        Assert.assertEquals((double)2.3E-12, (double)((Double)col4Summary.getMin()), (double)0.0);
        Assert.assertEquals((double)79.5, (double)((Double)col4Summary.getMax()), (double)1.0E-12);
        StringColumnSummary col5Summary = (StringColumnSummary)results.getField(5);
        Assert.assertEquals((long)8L, (long)col5Summary.getTotalCount());
        Assert.assertEquals((long)0L, (long)col5Summary.getNullCount());
        Assert.assertEquals((long)8L, (long)col5Summary.getNonNullCount());
        Assert.assertEquals((long)2L, (long)col5Summary.getEmptyCount());
        Assert.assertEquals((long)0L, (long)col5Summary.getMinLength().intValue());
        Assert.assertEquals((long)16L, (long)col5Summary.getMaxLength().intValue());
        Assert.assertEquals((double)5.0, (double)col5Summary.getMeanLength(), (double)1.0E-4);
        BooleanColumnSummary col6Summary = (BooleanColumnSummary)results.getField(6);
        Assert.assertEquals((long)8L, (long)col6Summary.getTotalCount());
        Assert.assertEquals((long)2L, (long)col6Summary.getFalseCount());
        Assert.assertEquals((long)6L, (long)col6Summary.getTrueCount());
        Assert.assertEquals((long)0L, (long)col6Summary.getNullCount());
        NumericColumnSummary col7Summary = (NumericColumnSummary)results.getField(7);
        Assert.assertEquals((double)100.0, (double)((Double)col7Summary.getMax()), (double)1.0E-5);
        Assert.assertEquals((double)50.0, (double)((Double)col7Summary.getMin()), (double)1.0E-5);
    }
}

