/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.streaming.runtime;

import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.v2.DiscardingSink;
import org.apache.flink.streaming.api.functions.source.RichParallelSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.test.util.AbstractTestBase;
import org.junit.Assert;
import org.junit.Test;

public class ChainedRuntimeContextITCase
extends AbstractTestBase {
    private static RuntimeContext srcContext;
    private static RuntimeContext mapContext;

    @Test
    public void test() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(1);
        env.addSource((SourceFunction)new TestSource()).map((MapFunction)new TestMap()).sinkTo((Sink)new DiscardingSink());
        env.execute();
        Assert.assertNotEquals((Object)srcContext, (Object)mapContext);
    }

    private static class TestMap
    extends RichMapFunction<Integer, Integer> {
        private TestMap() {
        }

        public Integer map(Integer value) throws Exception {
            return value;
        }

        public void open(OpenContext openContext) {
            mapContext = this.getRuntimeContext();
        }
    }

    private static class TestSource
    extends RichParallelSourceFunction<Integer> {
        private TestSource() {
        }

        public void run(SourceFunction.SourceContext<Integer> ctx) throws Exception {
        }

        public void cancel() {
        }

        public void open(OpenContext openContext) {
            srcContext = this.getRuntimeContext();
        }
    }
}

