/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.streaming.api.functions.source;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.serialization.SimpleStringEncoder;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.connector.file.sink.FileSink;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.filesystem.OutputFileConfig;
import org.apache.flink.streaming.api.functions.sink.filesystem.RollingPolicy;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.DefaultRollingPolicy;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ContinuousFileReaderOperatorITCase {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void testChainedOperatorsAreNotPrematurelyClosed() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(1);
        File input = this.temp.newFile("input");
        FileUtils.write((File)input, (CharSequence)"test", (Charset)StandardCharsets.UTF_8);
        DataStreamSource stream = env.readTextFile(input.getAbsolutePath());
        FileSink sink = ((FileSink.DefaultRowFormatBuilder)((FileSink.DefaultRowFormatBuilder)FileSink.forRowFormat((Path)new Path(this.temp.newFolder("output").getAbsolutePath()), (Encoder)new SimpleStringEncoder()).withOutputFileConfig(OutputFileConfig.builder().build())).withRollingPolicy((RollingPolicy)DefaultRollingPolicy.builder().withMaxPartSize(MemorySize.ofMebiBytes((long)1L)).build())).build();
        stream.sinkTo((Sink)sink);
        env.execute("test");
    }
}

