/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.streaming.api.environment;

import java.io.Serializable;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.LocalStreamEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class LocalStreamEnvironmentITCase
extends TestLogger {
    @Test
    public void testRunIsolatedJob() throws Exception {
        LocalStreamEnvironment env = new LocalStreamEnvironment();
        Assert.assertEquals((long)1L, (long)env.getParallelism());
        LocalStreamEnvironmentITCase.addSmallBoundedJob((StreamExecutionEnvironment)env, 3);
        env.execute();
    }

    @Test
    public void testMultipleJobsAfterAnother() throws Exception {
        LocalStreamEnvironment env = new LocalStreamEnvironment();
        LocalStreamEnvironmentITCase.addSmallBoundedJob((StreamExecutionEnvironment)env, 3);
        env.execute();
        LocalStreamEnvironmentITCase.addSmallBoundedJob((StreamExecutionEnvironment)env, 5);
        env.execute();
    }

    private static void addSmallBoundedJob(StreamExecutionEnvironment env, int parallelism) {
        DataStreamSource stream = env.fromSequence(1L, 100L).setParallelism(parallelism);
        stream.filter((FilterFunction & Serializable)ignored -> false).setParallelism(parallelism).startNewChain().print().setParallelism(parallelism);
    }
}

