/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.runtime;

import org.apache.flink.api.common.JobID;
import org.apache.flink.client.program.MiniClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;

public class JobGraphRunningUtil {
    public static void execute(JobGraph jobGraph, Configuration configuration, int numTaskManagers, int numSlotsPerTaskManager) throws Exception {
        configuration.set(TaskManagerOptions.TOTAL_FLINK_MEMORY, (Object)MemorySize.parse((String)"1g"));
        MiniClusterConfiguration miniClusterConfiguration = new MiniClusterConfiguration.Builder().withRandomPorts().setConfiguration(configuration).setNumTaskManagers(numTaskManagers).setNumSlotsPerTaskManager(numSlotsPerTaskManager).build();
        try (MiniCluster miniCluster = new MiniCluster(miniClusterConfiguration);){
            miniCluster.start();
            MiniClusterClient miniClusterClient = new MiniClusterClient(configuration, miniCluster);
            JobID jobID = (JobID)miniClusterClient.submitJob(jobGraph).get();
            JobResult jobResult = (JobResult)miniClusterClient.requestJobResult(jobID).get();
            if (jobResult.getSerializedThrowable().isPresent()) {
                throw new AssertionError(jobResult.getSerializedThrowable().get());
            }
        }
    }
}

