/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recovery;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RpcOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.entrypoint.ClusterEntrypointUtils;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.apache.flink.shaded.guava31.com.google.common.collect.Iterables;
import org.apache.flink.test.recovery.AbstractTaskManagerProcessFailureRecoveryTest;
import org.apache.flink.test.recovery.utils.TaskExecutorProcessEntryPoint;
import org.apache.flink.test.util.TestProcessBuilder;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TaskManagerRunnerITCase
extends TestLogger {
    @ClassRule
    public static final TemporaryFolder TEMPORARY_FOLDER = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeterministicWorkingDirIsNotDeletedInCaseOfProcessFailure() throws Exception {
        File workingDirBase = TEMPORARY_FOLDER.newFolder();
        ResourceID resourceId = ResourceID.generate();
        Configuration configuration = new Configuration();
        configuration.set(ClusterOptions.PROCESS_WORKING_DIR_BASE, (Object)workingDirBase.getAbsolutePath());
        configuration.set(TaskManagerOptions.TASK_MANAGER_RESOURCE_ID, (Object)resourceId.toString());
        configuration.set(JobManagerOptions.ADDRESS, (Object)"localhost");
        configuration.set(RpcOptions.LOOKUP_TIMEOUT_DURATION, (Object)Duration.ZERO);
        File workingDirectory = ClusterEntrypointUtils.generateTaskManagerWorkingDirectoryFile((Configuration)configuration, (ResourceID)resourceId);
        TestProcessBuilder.TestProcess taskManagerProcess = new TestProcessBuilder(TaskExecutorProcessEntryPoint.class.getName()).addConfigAsMainClassArgs(configuration).start();
        boolean success = false;
        try {
            CommonTestUtils.waitUntilCondition(workingDirectory::exists);
            taskManagerProcess.getProcess().destroy();
            taskManagerProcess.getProcess().waitFor();
            Assert.assertTrue((boolean)workingDirectory.exists());
            success = true;
        }
        finally {
            if (!success) {
                AbstractTaskManagerProcessFailureRecoveryTest.printProcessLog("TaskManager", taskManagerProcess);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNondeterministicWorkingDirIsDeletedInCaseOfProcessFailure() throws Exception {
        File workingDirBase = TEMPORARY_FOLDER.newFolder();
        Configuration configuration = new Configuration();
        configuration.set(ClusterOptions.PROCESS_WORKING_DIR_BASE, (Object)workingDirBase.getAbsolutePath());
        configuration.set(JobManagerOptions.ADDRESS, (Object)"localhost");
        configuration.set(RpcOptions.LOOKUP_TIMEOUT_DURATION, (Object)Duration.ZERO);
        TestProcessBuilder.TestProcess taskManagerProcess = new TestProcessBuilder(TaskExecutorProcessEntryPoint.class.getName()).addConfigAsMainClassArgs(configuration).start();
        boolean success = false;
        try {
            CommonTestUtils.waitUntilCondition(() -> {
                try (Stream<Path> files = Files.list(workingDirBase.toPath());){
                    Boolean bl = files.findAny().isPresent();
                    return bl;
                }
            });
            File workingDirectory = ((Path)Iterables.getOnlyElement((Iterable)Files.list(workingDirBase.toPath()).collect(Collectors.toList()))).toFile();
            taskManagerProcess.getProcess().destroy();
            taskManagerProcess.getProcess().waitFor();
            Assert.assertFalse((boolean)workingDirectory.exists());
            success = true;
        }
        finally {
            if (!success) {
                AbstractTaskManagerProcessFailureRecoveryTest.printProcessLog("TaskManager", taskManagerProcess);
            }
        }
    }
}

