/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.cancelling;

import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.test.cancelling.CancelingTestBase;
import org.apache.flink.test.util.InfiniteIntegerInputFormat;
import org.junit.Test;

public class MapCancelingITCase
extends CancelingTestBase {
    @Test
    public void testMapCancelling() throws Exception {
        this.executeTask(new IdentityMapper<Integer>());
    }

    @Test
    public void testSlowMapCancelling() throws Exception {
        this.executeTask(new DelayingIdentityMapper<Integer>());
    }

    @Test
    public void testMapWithLongCancellingResponse() throws Exception {
        this.executeTask(new LongCancelTimeIdentityMapper<Integer>());
    }

    @Test
    public void testMapPriorToFirstRecordReading() throws Exception {
        this.executeTask((MapFunction<Integer, Integer>)new StuckInOpenIdentityMapper());
    }

    public void executeTask(MapFunction<Integer, Integer> mapper) throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.createInput((InputFormat)new InfiniteIntegerInputFormat(false)).map(mapper).output((OutputFormat)new DiscardingOutputFormat());
        env.setParallelism(4);
        this.runAndCancelJob(env.createProgramPlan(), 5000, 10000);
    }

    private static final class StuckInOpenIdentityMapper<IN>
    extends RichMapFunction<IN, IN> {
        private static final long serialVersionUID = 1L;

        private StuckInOpenIdentityMapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void open(OpenContext openContext) throws Exception {
            StuckInOpenIdentityMapper stuckInOpenIdentityMapper = this;
            synchronized (stuckInOpenIdentityMapper) {
                ((Object)((Object)this)).wait();
            }
        }

        public IN map(IN value) throws Exception {
            return value;
        }
    }

    private static final class LongCancelTimeIdentityMapper<IN>
    implements MapFunction<IN, IN> {
        private static final long serialVersionUID = 1L;
        private static final int WAIT_TIME_PER_VALUE = 5000;

        private LongCancelTimeIdentityMapper() {
        }

        public IN map(IN value) throws Exception {
            long start = System.currentTimeMillis();
            long remaining = 5000L;
            do {
                try {
                    Thread.sleep(remaining);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while ((remaining = 5000L - System.currentTimeMillis() + start) > 0L);
            return value;
        }
    }

    private static final class DelayingIdentityMapper<IN>
    implements MapFunction<IN, IN> {
        private static final long serialVersionUID = 1L;
        private static final int WAIT_TIME_PER_VALUE = 10000;

        private DelayingIdentityMapper() {
        }

        public IN map(IN value) throws Exception {
            Thread.sleep(10000L);
            return value;
        }
    }

    private static final class IdentityMapper<IN>
    implements MapFunction<IN, IN> {
        private static final long serialVersionUID = 1L;

        private IdentityMapper() {
        }

        public IN map(IN value) throws Exception {
            return value;
        }
    }
}

