/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.operators;

import java.util.List;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.DistinctOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.ProjectOperator;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.test.operators.util.CollectionDataSets;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DistinctITCase
extends MultipleProgramsTestBase {
    public DistinctITCase(MultipleProgramsTestBase.TestExecutionMode mode) {
        super(mode);
    }

    @Test
    public void testCorrectnessOfDistinctOnTuplesWithKeyFieldSelector() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.getSmall3TupleDataSet(env);
        DistinctOperator distinctDs = ds.union(ds).distinct(new int[]{0, 1, 2});
        List result = distinctDs.collect();
        String expected = "1,1,Hi\n2,2,Hello\n3,2,Hello world\n";
        DistinctITCase.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testCorrectnessOfDistinctOnTuplesWithKeyFieldSelectorWithNotAllFieldsSelected() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds = CollectionDataSets.getSmall5TupleDataSet(env);
        ProjectOperator distinctDs = ds.union(ds).distinct(new int[]{0}).project(new int[]{0});
        List result = distinctDs.collect();
        String expected = "1\n2\n";
        DistinctITCase.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testCorrectnessOfDistinctOnTuplesWithKeyExtractorFunction() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds = CollectionDataSets.getSmall5TupleDataSet(env);
        ProjectOperator reduceDs = ds.union(ds).distinct((KeySelector)new KeySelector1()).project(new int[]{0});
        List result = reduceDs.collect();
        String expected = "1\n2\n";
        DistinctITCase.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testCorrectnessOfDistinctOnCustomTypeWithTypeExtractor() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CollectionDataSets.CustomType> ds = CollectionDataSets.getCustomTypeDataSet(env);
        MapOperator reduceDs = ds.distinct((KeySelector)new KeySelector3()).map((MapFunction)new Mapper3());
        List result = reduceDs.collect();
        String expected = "1\n2\n3\n4\n5\n6\n";
        DistinctITCase.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testCorrectnessOfDistinctOnTuples() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.getSmall3TupleDataSet(env);
        DistinctOperator distinctDs = ds.union(ds).distinct();
        List result = distinctDs.collect();
        String expected = "1,1,Hi\n2,2,Hello\n3,2,Hello world\n";
        DistinctITCase.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testCorrectnessOfDistinctOnCustomTypeWithTupleReturningTypeExtractor() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds = CollectionDataSets.get5TupleDataSet(env);
        ProjectOperator reduceDs = ds.distinct((KeySelector)new KeySelector2()).project(new int[]{0, 4});
        List result = reduceDs.collect();
        String expected = "1,1\n2,1\n2,2\n3,2\n3,3\n4,1\n4,2\n5,1\n5,2\n5,3\n";
        DistinctITCase.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testCorrectnessOfDistinctOnTuplesWithFieldExpressions() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds = CollectionDataSets.getSmall5TupleDataSet(env);
        ProjectOperator reduceDs = ds.union(ds).distinct(new String[]{"f0"}).project(new int[]{0});
        List result = reduceDs.collect();
        String expected = "1\n2\n";
        DistinctITCase.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testCorrectnessOfDistinctOnPojos() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CollectionDataSets.POJO> ds = CollectionDataSets.getDuplicatePojoDataSet(env);
        MapOperator reduceDs = ds.distinct(new String[]{"nestedPojo.longNumber"}).map((MapFunction)new Mapper2());
        List result = reduceDs.collect();
        String expected = "10000\n20000\n30000\n";
        DistinctITCase.compareResultAsText((List)result, (String)expected);
    }

    @Test
    public void testDistinctOnFullPojo() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CollectionDataSets.POJO> ds = CollectionDataSets.getDuplicatePojoDataSet(env);
        MapOperator reduceDs = ds.distinct().map((MapFunction)new Mapper1());
        List result = reduceDs.collect();
        String expected = "10000\n20000\n30000\n";
        DistinctITCase.compareResultAsText((List)result, (String)expected);
    }

    @Test
    public void testCorrectnessOfDistinctOnAtomic() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Integer> ds = CollectionDataSets.getIntegerDataSet(env);
        DistinctOperator reduceDs = ds.distinct();
        List result = reduceDs.collect();
        String expected = "1\n2\n3\n4\n5";
        DistinctITCase.compareResultAsText((List)result, (String)expected);
    }

    @Test
    public void testCorrectnessOfDistinctOnAtomicWithSelectAllChar() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<String> ds = CollectionDataSets.getStringDataSet(env);
        DistinctOperator reduceDs = ds.union(ds).distinct(new String[]{"*"});
        List result = reduceDs.collect();
        String expected = "I am fine.\nLuke Skywalker\nLOL\nHello world, how are you?\nHi\nHello world\nHello\nRandom comment\n";
        DistinctITCase.compareResultAsText((List)result, (String)expected);
    }

    private static class Mapper1
    implements MapFunction<CollectionDataSets.POJO, Integer> {
        private Mapper1() {
        }

        public Integer map(CollectionDataSets.POJO value) throws Exception {
            return (int)value.nestedPojo.longNumber;
        }
    }

    private static class Mapper2
    implements MapFunction<CollectionDataSets.POJO, Integer> {
        private Mapper2() {
        }

        public Integer map(CollectionDataSets.POJO value) throws Exception {
            return (int)value.nestedPojo.longNumber;
        }
    }

    private static class KeySelector2
    implements KeySelector<Tuple5<Integer, Long, Integer, String, Long>, Tuple2<Integer, Long>> {
        private static final long serialVersionUID = 1L;

        private KeySelector2() {
        }

        public Tuple2<Integer, Long> getKey(Tuple5<Integer, Long, Integer, String, Long> t) {
            return new Tuple2(t.f0, t.f4);
        }
    }

    private static class KeySelector3
    implements KeySelector<CollectionDataSets.CustomType, Integer> {
        private static final long serialVersionUID = 1L;

        private KeySelector3() {
        }

        public Integer getKey(CollectionDataSets.CustomType in) {
            return in.myInt;
        }
    }

    private static class Mapper3
    extends RichMapFunction<CollectionDataSets.CustomType, Tuple1<Integer>> {
        private Mapper3() {
        }

        public Tuple1<Integer> map(CollectionDataSets.CustomType value) throws Exception {
            return new Tuple1((Object)value.myInt);
        }
    }

    private static class KeySelector1
    implements KeySelector<Tuple5<Integer, Long, Integer, String, Long>, Integer> {
        private static final long serialVersionUID = 1L;

        private KeySelector1() {
        }

        public Integer getKey(Tuple5<Integer, Long, Integer, String, Long> in) {
            return (Integer)in.f0;
        }
    }
}

