/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.operators;

import java.util.List;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.aggregation.Aggregations;
import org.apache.flink.api.java.operators.ProjectOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.test.operators.util.CollectionDataSets;
import org.apache.flink.test.operators.util.ValueCollectionDataSets;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.StringValue;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AggregateITCase
extends MultipleProgramsTestBase {
    public AggregateITCase(MultipleProgramsTestBase.TestExecutionMode mode) {
        super(mode);
    }

    @Test
    public void testFullAggregate() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
        ProjectOperator aggregateDs = ds.aggregate(Aggregations.SUM, 0).and(Aggregations.MAX, 1).project(new int[]{0, 1});
        List result = aggregateDs.collect();
        String expected = "231,6\n";
        AggregateITCase.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testFullAggregateOfMutableValueTypes() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<IntValue, LongValue, StringValue>> ds = ValueCollectionDataSets.get3TupleDataSet(env);
        ProjectOperator aggregateDs = ds.aggregate(Aggregations.SUM, 0).and(Aggregations.MAX, 1).project(new int[]{0, 1});
        List result = aggregateDs.collect();
        String expected = "231,6\n";
        AggregateITCase.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testGroupedAggregate() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
        ProjectOperator aggregateDs = ds.groupBy(new int[]{1}).aggregate(Aggregations.SUM, 0).project(new int[]{1, 0});
        List result = aggregateDs.collect();
        String expected = "1,1\n2,5\n3,15\n4,34\n5,65\n6,111\n";
        AggregateITCase.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testGroupedAggregateOfMutableValueTypes() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<IntValue, LongValue, StringValue>> ds = ValueCollectionDataSets.get3TupleDataSet(env);
        ProjectOperator aggregateDs = ds.groupBy(new int[]{1}).aggregate(Aggregations.SUM, 0).project(new int[]{1, 0});
        List result = aggregateDs.collect();
        String expected = "1,1\n2,5\n3,15\n4,34\n5,65\n6,111\n";
        AggregateITCase.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testNestedAggregate() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
        ProjectOperator aggregateDs = ds.groupBy(new int[]{1}).aggregate(Aggregations.MIN, 0).aggregate(Aggregations.MIN, 0).project(new int[]{0});
        List result = aggregateDs.collect();
        String expected = "1\n";
        AggregateITCase.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testNestedAggregateOfMutableValueTypes() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<IntValue, LongValue, StringValue>> ds = ValueCollectionDataSets.get3TupleDataSet(env);
        ProjectOperator aggregateDs = ds.groupBy(new int[]{1}).aggregate(Aggregations.MIN, 0).aggregate(Aggregations.MIN, 0).project(new int[]{0});
        List result = aggregateDs.collect();
        String expected = "1\n";
        AggregateITCase.compareResultAsTuples((List)result, (String)expected);
    }
}

