/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.checkpointing;

import java.util.Arrays;
import java.util.Collections;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.functions.source.RichParallelSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.test.util.MiniClusterWithClientResource;
import org.apache.flink.test.util.SuccessException;
import org.apache.flink.test.util.TestUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

@Ignore(value="Approximate local recovery has currently no scheduler support")
public class ApproximateLocalRecoveryDownstreamITCase
extends TestLogger {
    private static final int BUFFER_SIZE = 4096;
    @Rule
    public MiniClusterWithClientResource cluster = new MiniClusterWithClientResource(new MiniClusterResourceConfiguration.Builder().setConfiguration(ApproximateLocalRecoveryDownstreamITCase.createConfig()).setNumberTaskManagers(4).setNumberSlotsPerTaskManager(1).build());
    @Rule
    public final Timeout timeout = Timeout.millis((long)300000L);

    @Test
    public void localTaskFailureRecoveryThreeTasks() throws Exception {
        int failAfterElements = 150;
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(1).setBufferTimeout(0L).setMaxParallelism(128).disableOperatorChaining().setRestartStrategy(RestartStrategies.fixedDelayRestart((int)1, (long)0L));
        env.getCheckpointConfig().enableApproximateLocalRecovery(true);
        env.addSource((SourceFunction)new AppSourceFunction()).slotSharingGroup("source").map(new FailingMapper(150)).slotSharingGroup("map").addSink((SinkFunction)new ValidatingAtMostOnceSink(300)).slotSharingGroup("sink");
        FailingMapper.failedBefore = false;
        TestUtils.tryExecute(env, "testThreeTasks");
    }

    @Test
    public void localTaskFailureRecoveryTwoMapTasks() throws Exception {
        int failAfterElements = 20;
        int keyByChannelNumber = 2;
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(1).setBufferTimeout(0L).disableOperatorChaining().setMaxParallelism(128).setRestartStrategy(RestartStrategies.fixedDelayRestart((int)1, (long)0L));
        env.getCheckpointConfig().enableApproximateLocalRecovery(true);
        env.addSource((SourceFunction)new AppSourceFunction(4096, env.getMaxParallelism(), 2)).slotSharingGroup("source").keyBy(InvertedKeyTuple::key).map(new FailingMapper(20)).setParallelism(2).slotSharingGroup("map").addSink((SinkFunction)new ValidatingAtMostOnceSink(200, 2)).slotSharingGroup("sink");
        FailingMapper.failedBefore = false;
        TestUtils.tryExecute(env, "testTwoMapTasks");
    }

    private static Configuration createConfig() {
        Configuration config = new Configuration();
        config.set(TaskManagerOptions.MEMORY_SEGMENT_SIZE, (Object)MemorySize.parse((String)Integer.toString(4096)));
        return config;
    }

    private static class InvertedKeyTuple {
        int index;
        int key;
        int selectedChannel;
        String longOrShortString;

        InvertedKeyTuple(int index, int key, int selectedChannel, String longOrShortString) {
            this.index = index;
            this.key = key;
            this.selectedChannel = selectedChannel;
            this.longOrShortString = longOrShortString;
        }

        int key() {
            return this.key;
        }
    }

    private static class ValidatingAtMostOnceSink
    extends RichSinkFunction<InvertedKeyTuple> {
        private static final long serialVersionUID = 1748426382527469932L;
        private final int numElementsTotal;
        private final int[] numElements;
        private final Integer[] indexReachingNumElements;
        private final int numberOfInputChannels;

        ValidatingAtMostOnceSink(int numElementsTotal, int numberOfInputChannels) {
            this.numElementsTotal = numElementsTotal;
            this.numberOfInputChannels = numberOfInputChannels;
            this.numElements = new int[numberOfInputChannels];
            this.indexReachingNumElements = new Integer[numberOfInputChannels];
        }

        ValidatingAtMostOnceSink(int numElementsTotal) {
            this.numElementsTotal = numElementsTotal;
            this.numberOfInputChannels = 1;
            this.numElements = new int[this.numberOfInputChannels];
            this.indexReachingNumElements = new Integer[this.numberOfInputChannels];
        }

        public void invoke(InvertedKeyTuple tuple, SinkFunction.Context ctx) throws Exception {
            assert (tuple.selectedChannel < this.numberOfInputChannels);
            int n = tuple.selectedChannel;
            this.numElements[n] = this.numElements[n] + 1;
            boolean allReachNumElementsTotal = true;
            for (int i = 0; i < this.numberOfInputChannels; ++i) {
                if (this.numElements[i] == this.numElementsTotal) {
                    this.indexReachingNumElements[i] = tuple.index;
                    continue;
                }
                if (this.numElements[i] >= this.numElementsTotal) continue;
                allReachNumElementsTotal = false;
            }
            if (allReachNumElementsTotal) {
                assert (Collections.max(Arrays.asList(this.indexReachingNumElements)) >= this.numElementsTotal * this.numberOfInputChannels);
                throw new SuccessException();
            }
        }
    }

    private static class FailingMapper<T>
    extends RichMapFunction<T, T> {
        private static final long serialVersionUID = 6334389850158703L;
        private static volatile boolean failedBefore;
        private final int failCount;
        private int numElementsTotal;
        private boolean failer;

        FailingMapper(int failCount) {
            this.failCount = failCount;
        }

        public void open(Configuration parameters) {
            this.failer = this.getRuntimeContext().getIndexOfThisSubtask() == 0;
        }

        public T map(T value) throws Exception {
            ++this.numElementsTotal;
            if (!failedBefore) {
                Thread.sleep(10L);
                if (this.failer && this.numElementsTotal >= this.failCount) {
                    failedBefore = true;
                    throw new Exception("Artificial Test Failure");
                }
            }
            return value;
        }
    }

    private static class AppSourceFunction
    extends RichParallelSourceFunction<InvertedKeyTuple> {
        private final String shortString = "I am a very long string to test partial records hohoho hahaha ";
        private final String longOrShortString;
        private final int maxParallelism;
        private final int numberOfChannels;
        private final int[] keys;
        private int index = 0;
        private volatile boolean running = true;

        AppSourceFunction() {
            this.longOrShortString = "I am a very long string to test partial records hohoho hahaha ";
            this.maxParallelism = 128;
            this.numberOfChannels = 1;
            this.keys = this.initKeys(this.numberOfChannels);
        }

        AppSourceFunction(int bufferSize, int maxParallelism, int numberOfChannels) {
            this.maxParallelism = maxParallelism;
            this.numberOfChannels = numberOfChannels;
            this.keys = this.initKeys(numberOfChannels);
            StringBuilder builder = new StringBuilder("I am a very long string to test partial records hohoho hahaha ");
            for (int i = 0; i <= 2 * bufferSize / "I am a very long string to test partial records hohoho hahaha ".length() + 1; ++i) {
                builder.append("I am a very long string to test partial records hohoho hahaha ");
            }
            this.longOrShortString = builder.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(SourceFunction.SourceContext<InvertedKeyTuple> ctx) throws Exception {
            while (this.running) {
                Object object = ctx.getCheckpointLock();
                synchronized (object) {
                    if (this.index % 100 == 0) {
                        Thread.sleep(50L);
                    }
                    int selectedChannel = this.index % this.numberOfChannels;
                    int key = this.keys[selectedChannel];
                    ctx.collect((Object)new InvertedKeyTuple(this.index, key, selectedChannel, this.longOrShortString));
                }
                ++this.index;
            }
        }

        public void cancel() {
            this.running = false;
        }

        private int[] initKeys(int numberOfChannels) {
            int[] keys = new int[numberOfChannels];
            for (int i = 0; i < numberOfChannels; ++i) {
                int key;
                for (key = 0; key < 1000 && this.selectedChannel(key) != i; ++key) {
                }
                assert (key < 1000) : "Can not find a key within number 1000";
                keys[i] = key;
            }
            return keys;
        }

        private int selectedChannel(int key) {
            return KeyGroupRangeAssignment.assignKeyToParallelOperator((Object)key, (int)this.maxParallelism, (int)this.numberOfChannels);
        }
    }
}

