/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.io;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.io.POJOItem;
import org.apache.flink.api.scala.io.ScalaCsvReaderWithPOJOITCase$;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.util.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0001\u0003\u0001=\u0011AdU2bY\u0006\u001c5O\u001e*fC\u0012,'oV5uQB{%jT%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005\u0011\u0011n\u001c\u0006\u0003\u000b\u0019\tQa]2bY\u0006T!a\u0002\u0005\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E1R\"\u0001\n\u000b\u0005M!\u0012\u0001B;uS2T!!\u0006\u0005\u0002\tQ,7\u000f^\u0005\u0003/I\u0011\u0001$T;mi&\u0004H.\u001a)s_\u001e\u0014\u0018-\\:UKN$()Y:f\u0011!I\u0002A!A!\u0002\u0013Q\u0012\u0001B7pI\u0016\u0004\"aG\u0016\u000f\u0005qIcBA\u000f)\u001d\tqrE\u0004\u0002 M9\u0011\u0001%\n\b\u0003C\u0011j\u0011A\t\u0006\u0003G9\ta\u0001\u0010:p_Rt\u0014\"A\u0007\n\u0005-a\u0011BA\u0005\u000b\u0013\t)\u0002\"\u0003\u0002\u0014)%\u0011!FE\u0001\u0019\u001bVdG/\u001b9mKB\u0013xn\u001a:b[N$Vm\u001d;CCN,\u0017B\u0001\u0017.\u0005E!Vm\u001d;Fq\u0016\u001cW\u000f^5p]6{G-\u001a\u0006\u0003UIAQa\f\u0001\u0005\u0002A\na\u0001P5oSRtDCA\u00194!\t\u0011\u0004!D\u0001\u0003\u0011\u0015Ib\u00061\u0001\u001b\u0011\u001d)\u0004A1A\u0005\nY\n1b\u0018;f[B4u\u000e\u001c3feV\tq\u0007\u0005\u00029{5\t\u0011H\u0003\u0002;w\u0005)!/\u001e7fg*\u0011A\bD\u0001\u0006UVt\u0017\u000e^\u0005\u0003}e\u0012q\u0002V3na>\u0014\u0018M]=G_2$WM\u001d\u0005\u0007\u0001\u0002\u0001\u000b\u0011B\u001c\u0002\u0019}#X-\u001c9G_2$WM\u001d\u0011\t\u000f\t\u0003\u0001\u0019!C\u0005\u0007\u0006Q!/Z:vYR\u0004\u0016\r\u001e5\u0016\u0003\u0011\u0003\"!\u0012&\u000f\u0005\u0019C\u0005CA\u0011H\u0015\u0005)\u0011BA%H\u0003\u0019\u0001&/\u001a3fM&\u00111\n\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%;\u0005b\u0002(\u0001\u0001\u0004%IaT\u0001\u000fe\u0016\u001cX\u000f\u001c;QCRDw\fJ3r)\t\u0001F\u000b\u0005\u0002R%6\tq)\u0003\u0002T\u000f\n!QK\\5u\u0011\u001d)V*!AA\u0002\u0011\u000b1\u0001\u001f\u00132\u0011\u00199\u0006\u0001)Q\u0005\t\u0006Y!/Z:vYR\u0004\u0016\r\u001e5!\u0011\u001dI\u0006\u00011A\u0005\n\r\u000b\u0001\"\u001a=qK\u000e$X\r\u001a\u0005\b7\u0002\u0001\r\u0011\"\u0003]\u00031)\u0007\u0010]3di\u0016$w\fJ3r)\t\u0001V\fC\u0004V5\u0006\u0005\t\u0019\u0001#\t\r}\u0003\u0001\u0015)\u0003E\u0003%)\u0007\u0010]3di\u0016$\u0007\u0005C\u0003b\u0001\u0011\u0005a'\u0001\u0006uK6\u0004hi\u001c7eKJD#\u0001Y2\u0011\u0005\u0011,W\"A\u001e\n\u0005\u0019\\$\u0001\u0002*vY\u0016DQ\u0001\u001b\u0001\u0005\u0002%\faAY3g_J,G#\u0001))\u0005\u001d\\\u0007C\u00013m\u0013\ti7H\u0001\u0004CK\u001a|'/\u001a\u0005\u0006_\u0002!\t![\u0001\u0006C\u001a$XM\u001d\u0015\u0003]F\u0004\"\u0001\u001a:\n\u0005M\\$!B!gi\u0016\u0014\b\"B;\u0001\t\u00031\u0018aD2sK\u0006$X-\u00138qkR$\u0015\r^1\u0015\u0005\u0011;\b\"\u0002=u\u0001\u0004!\u0015\u0001\u00023bi\u0006DQA\u001f\u0001\u0005\u0002%\fA\u0002^3tiB{%j\u0014+za\u0016D#!\u001f?\u0011\u0005\u0011l\u0018B\u0001@<\u0005\u0011!Vm\u001d;\t\r\u0005\u0005\u0001\u0001\"\u0001j\u0003m!Xm\u001d;Q\u001f*{E+\u001f9f/&$\bNR5fY\u0012\u001cxJ\u001d3fe\"\u0012q\u0010 \u0005\u0007\u0003\u000f\u0001A\u0011A5\u0002=Q,7\u000f\u001e)P\u0015>#\u0016\u0010]3XSRDw.\u001e;GS\u0016dGm](sI\u0016\u0014\bfAA\u0003y\"1\u0011Q\u0002\u0001\u0005\u0002%\fQ\u0006^3tiB{%j\u0014+za\u0016<\u0016\u000e\u001e5GS\u0016dGm](sI\u0016\u0014\u0018I\u001c3GS\u0016dGm]*fY\u0016\u001cG/[8oQ\r\tY\u0001 \u0015\b\u0001\u0005M\u0011qDA\u0011!\u0011\t)\"a\u0007\u000e\u0005\u0005]!bAA\rw\u00051!/\u001e8oKJLA!!\b\u0002\u0018\t9!+\u001e8XSRD\u0017!\u0002<bYV,7EAA\u0012!\u0011\t)#a\u000b\u000e\u0005\u0005\u001d\"bAA\u0015w\u00059!/\u001e8oKJ\u001c\u0018\u0002BA\u0017\u0003O\u0011Q\u0002U1sC6,G/\u001a:ju\u0016$\u0007")
public class ScalaCsvReaderWithPOJOITCase
extends MultipleProgramsTestBase {
    private final TemporaryFolder _tempFolder = new TemporaryFolder();
    private String resultPath = null;
    private String expected = null;

    private TemporaryFolder _tempFolder() {
        return this._tempFolder;
    }

    private String resultPath() {
        return this.resultPath;
    }

    private void resultPath_$eq(String x$1) {
        this.resultPath = x$1;
    }

    private String expected() {
        return this.expected;
    }

    private void expected_$eq(String x$1) {
        this.expected = x$1;
    }

    @Rule
    public TemporaryFolder tempFolder() {
        return this._tempFolder();
    }

    @Before
    public void before() {
        this.resultPath_$eq(this.tempFolder().newFile("result").toURI().toString());
    }

    @After
    public void after() {
        TestBaseUtils.compareResultsByLinesInMemory((String)this.expected(), (String)this.resultPath());
    }

    public String createInputData(String data) {
        File dataFile = this.tempFolder().newFile("data");
        FileUtils.writeFileUtf8((File)dataFile, (String)data);
        return dataFile.toURI().toString();
    }

    @Test
    public void testPOJOType() {
        GenericTypeInfo genericTypeInfo;
        Class<POJOItem> clazz;
        String dataPath = this.createInputData("ABC,2.20,3\nDEF,5.1,5\nDEF,3.30,1\nGHI,3.30,10");
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        String x$1 = dataPath;
        String[] x$2 = (String[])((Object[])new String[]{"f1", "f2", "f3"});
        String x$3 = env.readCsvFile$default$2();
        String x$4 = env.readCsvFile$default$3();
        Character x$5 = env.readCsvFile$default$4();
        boolean x$6 = env.readCsvFile$default$5();
        String x$7 = env.readCsvFile$default$6();
        boolean x$8 = env.readCsvFile$default$7();
        int[] x$9 = env.readCsvFile$default$8();
        ClassTag classTag = ClassTag$.MODULE$.apply(POJOItem.class);
        .colon.colon fields = new .colon.colon((Object)new Tuple2((Object)"f3", (Object)BasicTypeInfo.getInfoFor(Integer.TYPE)), (List)new .colon.colon((Object)new Tuple2((Object)"f2", (Object)BasicTypeInfo.getInfoFor(Double.TYPE)), (List)new .colon.colon((Object)new Tuple2((Object)"f1", (Object)BasicTypeInfo.getInfoFor(String.class)), (List)Nil$.MODULE$)));
        Map clazzFields = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef error = BooleanRef.create((boolean)false);
        for (Class traversalClazz = clazz = POJOItem.class; traversalClazz != null; traversalClazz = traversalClazz.getSuperclass()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])traversalClazz.getDeclaredFields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
                block0: {
                    if (!clazzFields.contains((Object)field.getName()) || Modifier.isStatic(field.getModifiers())) break block0;
                    Predef$.MODULE$.println((Object)new StringBuilder(59).append("The field ").append(field).append(" is already contained in the ").append(new StringBuilder(66).append("hierarchy of the class ").append(clazz).append(". Please use unique field names throughout ").toString()).append("your class hierarchy").toString());
                    error$1.elem = true;
                }
                return (Map)clazzFields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), field));
            });
        }
        if (error.elem) {
            genericTypeInfo = new GenericTypeInfo(clazz);
        } else {
            List pojoFields = (List)fields.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String fName = (String)tuple2._1();
                BasicTypeInfo fTpe = (BasicTypeInfo)tuple2._2();
                Field field = (Field)clazzFields.apply((Object)fName);
                Iterable iterable = Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)new PojoField((Field)clazzFields.apply((Object)fName), (TypeInformation)fTpe)));
                return iterable;
            }, List$.MODULE$.canBuildFrom());
            genericTypeInfo = new PojoTypeInfo(clazz, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pojoFields).asJava());
        }
        DataSet data = env.readCsvFile(x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$2, classTag, (TypeInformation)genericTypeInfo);
        CaseClassTypeInfo<Tuple2<String, Object>> typeInfo = new CaseClassTypeInfo<Tuple2<String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<String, Object>> unused = new ScalaCaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.api.scala.io.ScalaCsvReaderWithPOJOITCase$$anon$4 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        };
        data.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("ABC,2.20,3\nDEF,5.10,5\nDEF,3.30,1\nGHI,3.30,10");
    }

    @Test
    public void testPOJOTypeWithFieldsOrder() {
        GenericTypeInfo genericTypeInfo;
        Class<POJOItem> clazz;
        String dataPath = this.createInputData("2.20,ABC,3\n5.1,DEF,5\n3.30,DEF,1\n3.30,GHI,10");
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        String x$10 = dataPath;
        String[] x$11 = (String[])((Object[])new String[]{"f2", "f1", "f3"});
        String x$12 = env.readCsvFile$default$2();
        String x$13 = env.readCsvFile$default$3();
        Character x$14 = env.readCsvFile$default$4();
        boolean x$15 = env.readCsvFile$default$5();
        String x$16 = env.readCsvFile$default$6();
        boolean x$17 = env.readCsvFile$default$7();
        int[] x$18 = env.readCsvFile$default$8();
        ClassTag classTag = ClassTag$.MODULE$.apply(POJOItem.class);
        .colon.colon fields = new .colon.colon((Object)new Tuple2((Object)"f3", (Object)BasicTypeInfo.getInfoFor(Integer.TYPE)), (List)new .colon.colon((Object)new Tuple2((Object)"f2", (Object)BasicTypeInfo.getInfoFor(Double.TYPE)), (List)new .colon.colon((Object)new Tuple2((Object)"f1", (Object)BasicTypeInfo.getInfoFor(String.class)), (List)Nil$.MODULE$)));
        Map clazzFields = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef error = BooleanRef.create((boolean)false);
        for (Class traversalClazz = clazz = POJOItem.class; traversalClazz != null; traversalClazz = traversalClazz.getSuperclass()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])traversalClazz.getDeclaredFields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
                block0: {
                    if (!clazzFields.contains((Object)field.getName()) || Modifier.isStatic(field.getModifiers())) break block0;
                    Predef$.MODULE$.println((Object)new StringBuilder(59).append("The field ").append(field).append(" is already contained in the ").append(new StringBuilder(66).append("hierarchy of the class ").append(clazz).append(". Please use unique field names throughout ").toString()).append("your class hierarchy").toString());
                    error$2.elem = true;
                }
                return (Map)clazzFields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), field));
            });
        }
        if (error.elem) {
            genericTypeInfo = new GenericTypeInfo(clazz);
        } else {
            List pojoFields = (List)fields.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String fName = (String)tuple2._1();
                BasicTypeInfo fTpe = (BasicTypeInfo)tuple2._2();
                Field field = (Field)clazzFields.apply((Object)fName);
                Iterable iterable = Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)new PojoField((Field)clazzFields.apply((Object)fName), (TypeInformation)fTpe)));
                return iterable;
            }, List$.MODULE$.canBuildFrom());
            genericTypeInfo = new PojoTypeInfo(clazz, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pojoFields).asJava());
        }
        DataSet data = env.readCsvFile(x$10, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$11, classTag, (TypeInformation)genericTypeInfo);
        CaseClassTypeInfo<Tuple2<String, Object>> typeInfo = new CaseClassTypeInfo<Tuple2<String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<String, Object>> unused = new ScalaCaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.api.scala.io.ScalaCsvReaderWithPOJOITCase$$anon$5 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        };
        data.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("ABC,2.20,3\nDEF,5.10,5\nDEF,3.30,1\nGHI,3.30,10");
    }

    @Test
    public void testPOJOTypeWithoutFieldsOrder() {
        String dataPath = this.createInputData("");
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        try {
            GenericTypeInfo genericTypeInfo;
            Class<POJOItem> clazz;
            String string = env.readCsvFile$default$2();
            String string2 = env.readCsvFile$default$3();
            Character c = env.readCsvFile$default$4();
            boolean bl = env.readCsvFile$default$5();
            String string3 = env.readCsvFile$default$6();
            boolean bl2 = env.readCsvFile$default$7();
            int[] nArray = env.readCsvFile$default$8();
            String[] stringArray = env.readCsvFile$default$9();
            ClassTag classTag = ClassTag$.MODULE$.apply(POJOItem.class);
            .colon.colon fields = new .colon.colon((Object)new Tuple2((Object)"f3", (Object)BasicTypeInfo.getInfoFor(Integer.TYPE)), (List)new .colon.colon((Object)new Tuple2((Object)"f2", (Object)BasicTypeInfo.getInfoFor(Double.TYPE)), (List)new .colon.colon((Object)new Tuple2((Object)"f1", (Object)BasicTypeInfo.getInfoFor(String.class)), (List)Nil$.MODULE$)));
            Map clazzFields = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            BooleanRef error = BooleanRef.create((boolean)false);
            for (Class traversalClazz = clazz = POJOItem.class; traversalClazz != null; traversalClazz = traversalClazz.getSuperclass()) {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])traversalClazz.getDeclaredFields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
                    block0: {
                        if (!clazzFields.contains((Object)field.getName()) || Modifier.isStatic(field.getModifiers())) break block0;
                        Predef$.MODULE$.println((Object)new StringBuilder(59).append("The field ").append(field).append(" is already contained in the ").append(new StringBuilder(66).append("hierarchy of the class ").append(clazz).append(". Please use unique field names throughout ").toString()).append("your class hierarchy").toString());
                        error$3.elem = true;
                    }
                    return (Map)clazzFields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), field));
                });
            }
            if (error.elem) {
                genericTypeInfo = new GenericTypeInfo(clazz);
            } else {
                List pojoFields = (List)fields.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String fName = (String)tuple2._1();
                    BasicTypeInfo fTpe = (BasicTypeInfo)tuple2._2();
                    Field field = (Field)clazzFields.apply((Object)fName);
                    Iterable iterable = Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)new PojoField((Field)clazzFields.apply((Object)fName), (TypeInformation)fTpe)));
                    return iterable;
                }, List$.MODULE$.canBuildFrom());
                genericTypeInfo = new PojoTypeInfo(clazz, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pojoFields).asJava());
            }
            DataSet data = env.readCsvFile(dataPath, string, string2, c, bl, string3, bl2, nArray, stringArray, classTag, (TypeInformation)genericTypeInfo);
            Assert.fail((String)"POJO type without fields order must raise IllegalArgumentException!");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.expected_$eq("");
        this.resultPath_$eq(dataPath);
    }

    @Test
    public void testPOJOTypeWithFieldsOrderAndFieldsSelection() {
        GenericTypeInfo genericTypeInfo;
        Class<POJOItem> clazz;
        String dataPath = this.createInputData("2.20,3,ABC\n5.1,5,DEF\n3.30,1,DEF\n3.30,10,GHI");
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        String x$19 = dataPath;
        int[] x$20 = new int[]{1, 2};
        String[] x$21 = (String[])((Object[])new String[]{"f3", "f1"});
        String x$22 = env.readCsvFile$default$2();
        String x$23 = env.readCsvFile$default$3();
        Character x$24 = env.readCsvFile$default$4();
        boolean x$25 = env.readCsvFile$default$5();
        String x$26 = env.readCsvFile$default$6();
        boolean x$27 = env.readCsvFile$default$7();
        ClassTag classTag = ClassTag$.MODULE$.apply(POJOItem.class);
        .colon.colon fields = new .colon.colon((Object)new Tuple2((Object)"f3", (Object)BasicTypeInfo.getInfoFor(Integer.TYPE)), (List)new .colon.colon((Object)new Tuple2((Object)"f2", (Object)BasicTypeInfo.getInfoFor(Double.TYPE)), (List)new .colon.colon((Object)new Tuple2((Object)"f1", (Object)BasicTypeInfo.getInfoFor(String.class)), (List)Nil$.MODULE$)));
        Map clazzFields = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef error = BooleanRef.create((boolean)false);
        for (Class traversalClazz = clazz = POJOItem.class; traversalClazz != null; traversalClazz = traversalClazz.getSuperclass()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])traversalClazz.getDeclaredFields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
                block0: {
                    if (!clazzFields.contains((Object)field.getName()) || Modifier.isStatic(field.getModifiers())) break block0;
                    Predef$.MODULE$.println((Object)new StringBuilder(59).append("The field ").append(field).append(" is already contained in the ").append(new StringBuilder(66).append("hierarchy of the class ").append(clazz).append(". Please use unique field names throughout ").toString()).append("your class hierarchy").toString());
                    error$4.elem = true;
                }
                return (Map)clazzFields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), field));
            });
        }
        if (error.elem) {
            genericTypeInfo = new GenericTypeInfo(clazz);
        } else {
            List pojoFields = (List)fields.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String fName = (String)tuple2._1();
                BasicTypeInfo fTpe = (BasicTypeInfo)tuple2._2();
                Field field = (Field)clazzFields.apply((Object)fName);
                Iterable iterable = Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)new PojoField((Field)clazzFields.apply((Object)fName), (TypeInformation)fTpe)));
                return iterable;
            }, List$.MODULE$.canBuildFrom());
            genericTypeInfo = new PojoTypeInfo(clazz, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pojoFields).asJava());
        }
        DataSet data = env.readCsvFile(x$19, x$22, x$23, x$24, x$25, x$26, x$27, x$20, x$21, classTag, (TypeInformation)genericTypeInfo);
        CaseClassTypeInfo<Tuple2<String, Object>> typeInfo = new CaseClassTypeInfo<Tuple2<String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<String, Object>> unused = new ScalaCaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.api.scala.io.ScalaCsvReaderWithPOJOITCase$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        };
        data.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("ABC,0.00,3\nDEF,0.00,5\nDEF,0.00,1\nGHI,0.00,10");
    }

    public ScalaCsvReaderWithPOJOITCase(MultipleProgramsTestBase.TestExecutionMode mode) {
        super(mode);
    }
}

