/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.streaming.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.client.ClientUtils;
import org.apache.flink.client.deployment.StandaloneClusterId;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.testutils.MiniClusterResource;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamingJobGraphGenerator;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class BigUserProgramJobSubmitITCase
extends TestLogger {
    @ClassRule
    public static final MiniClusterResource MINI_CLUSTER_RESOURCE = new MiniClusterResource(new MiniClusterResourceConfiguration.Builder().build());
    private final Random rnd = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void bigDataInMap() throws Exception {
        final byte[] data = new byte[0x1000000];
        this.rnd.nextBytes(data);
        data[1] = 0;
        data[3] = 0;
        data[5] = 0;
        CollectingSink resultSink = new CollectingSink();
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(1);
        DataStreamSource src = env.fromElements((Object[])new Integer[]{1, 3, 5});
        src.map((MapFunction)new MapFunction<Integer, String>(){
            private static final long serialVersionUID = 1L;

            public String map(Integer value) throws Exception {
                return "x " + value + " " + data[value];
            }
        }).addSink((SinkFunction)resultSink);
        JobGraph jobGraph = StreamingJobGraphGenerator.createJobGraph((StreamGraph)env.getStreamGraph());
        try (RestClusterClient restClusterClient = new RestClusterClient((Configuration)MINI_CLUSTER_RESOURCE.getClientConfiguration(), (Object)StandaloneClusterId.getInstance());){
            ClientUtils.submitJobAndWaitForResult((ClusterClient)restClusterClient, (JobGraph)jobGraph, (ClassLoader)BigUserProgramJobSubmitITCase.class.getClassLoader());
            List<String> expected = Arrays.asList("x 1 0", "x 3 0", "x 5 0");
            List result = CollectingSink.result;
            Collections.sort(expected);
            Collections.sort(result);
            Assert.assertEquals(expected, (Object)result);
        }
    }

    private static class CollectingSink
    implements SinkFunction<String> {
        private static final List<String> result = Collections.synchronizedList(new ArrayList(3));

        private CollectingSink() {
        }

        public void invoke(String value, SinkFunction.Context context) throws Exception {
            result.add(value);
        }
    }
}

