/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.state;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Set;
import org.apache.flink.runtime.state.StateObject;
import org.junit.Assert;
import org.junit.Test;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class StateHandleSerializationTest {
    @Test
    public void ensureStateHandlesHaveSerialVersionUID() {
        try {
            Reflections reflections = new Reflections("org.apache.flink", new Scanner[0]);
            Set stateHandleImplementations = reflections.getSubTypesOf(StateObject.class);
            for (Class clazz : stateHandleImplementations) {
                StateHandleSerializationTest.validataSerialVersionUID(clazz);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static void validataSerialVersionUID(Class<?> clazz) {
        if (!clazz.isInterface()) {
            Assert.assertFalse((String)("Anonymous state handle classes have problematic serialization behavior: " + clazz), (boolean)clazz.isAnonymousClass());
            try {
                Field versionUidField = clazz.getDeclaredField("serialVersionUID");
                if (!(Modifier.isPrivate(versionUidField.getModifiers()) && Modifier.isStatic(versionUidField.getModifiers()) && Modifier.isFinal(versionUidField.getModifiers()))) {
                    Assert.fail((String)(clazz.getName() + " - serialVersionUID is not 'private static final'"));
                }
            }
            catch (NoSuchFieldException e) {
                Assert.fail((String)("State handle implementation '" + clazz.getName() + "' is missing the serialVersionUID"));
            }
        }
    }
}

