/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.plugin;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.flink.core.plugin.DefaultPluginManager;
import org.apache.flink.core.plugin.DirectoryBasedPluginFinder;
import org.apache.flink.core.plugin.PluginDescriptor;
import org.apache.flink.shaded.guava18.com.google.common.collect.Lists;
import org.apache.flink.test.plugin.OtherTestSpi;
import org.apache.flink.test.plugin.PluginTestBase;
import org.apache.flink.test.plugin.TestSpi;
import org.apache.flink.util.Preconditions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class DefaultPluginManagerTest
extends PluginTestBase {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private Collection<PluginDescriptor> descriptors;

    @Before
    public void setup() throws Exception {
        File pluginRootFolder = this.temporaryFolder.newFolder();
        Path pluginRootFolderPath = pluginRootFolder.toPath();
        File pluginAFolder = new File(pluginRootFolder, "A");
        File pluginBFolder = new File(pluginRootFolder, "B");
        Preconditions.checkState((boolean)pluginAFolder.mkdirs());
        Preconditions.checkState((boolean)pluginBFolder.mkdirs());
        Files.copy(DefaultPluginManagerTest.locateJarFile("plugin-a-test-jar.jar").toPath(), Paths.get(pluginAFolder.toString(), "plugin-a-test-jar.jar"), new CopyOption[0]);
        Files.copy(DefaultPluginManagerTest.locateJarFile("plugin-b-test-jar.jar").toPath(), Paths.get(pluginBFolder.toString(), "plugin-b-test-jar.jar"), new CopyOption[0]);
        DirectoryBasedPluginFinder descriptorsFactory = new DirectoryBasedPluginFinder(pluginRootFolderPath);
        this.descriptors = descriptorsFactory.findPlugins();
        Preconditions.checkState((this.descriptors.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testPluginLoading() {
        String[] parentPatterns = new String[]{TestSpi.class.getName(), OtherTestSpi.class.getName()};
        DefaultPluginManager pluginManager = new DefaultPluginManager(this.descriptors, PARENT_CLASS_LOADER, parentPatterns);
        ArrayList serviceImplList = Lists.newArrayList((Iterator)pluginManager.load(TestSpi.class));
        Assert.assertEquals((long)2L, (long)serviceImplList.size());
        Set classLoaders = Collections.newSetFromMap(new IdentityHashMap(3));
        classLoaders.add(PARENT_CLASS_LOADER);
        for (TestSpi testSpi : serviceImplList) {
            Assert.assertNotNull((Object)testSpi.testMethod());
            Assert.assertTrue((boolean)classLoaders.add(testSpi.getClass().getClassLoader()));
        }
        ArrayList otherServiceImplList = Lists.newArrayList((Iterator)pluginManager.load(OtherTestSpi.class));
        Assert.assertEquals((long)1L, (long)otherServiceImplList.size());
        for (OtherTestSpi otherTestSpi : otherServiceImplList) {
            Assert.assertNotNull((Object)otherTestSpi.otherTestMethod());
            Assert.assertTrue((boolean)classLoaders.add(otherTestSpi.getClass().getClassLoader()));
        }
    }
}

