/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.example.failing;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.apache.flink.client.ClientUtils;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.testtasks.NoOpInvokable;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.test.util.MiniClusterWithClientResource;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JobSubmissionFailsITCase
extends TestLogger {
    private static final int NUM_TM = 2;
    private static final int NUM_SLOTS = 20;
    @ClassRule
    public static final MiniClusterWithClientResource MINI_CLUSTER_RESOURCE = new MiniClusterWithClientResource(new MiniClusterResourceConfiguration.Builder().setConfiguration(JobSubmissionFailsITCase.getConfiguration()).setNumberTaskManagers(2).setNumberSlotsPerTaskManager(10).build());
    private final boolean detached;

    private static Configuration getConfiguration() {
        Configuration config = new Configuration();
        config.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)MemorySize.parse((String)"4m"));
        config.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)MemorySize.parse((String)"256m"));
        return config;
    }

    private static JobGraph getWorkingJobGraph() {
        JobVertex jobVertex = new JobVertex("Working job vertex.");
        jobVertex.setInvokableClass(NoOpInvokable.class);
        return new JobGraph("Working testing job", new JobVertex[]{jobVertex});
    }

    public JobSubmissionFailsITCase(boolean detached) {
        this.detached = detached;
    }

    @Parameterized.Parameters(name="Detached mode = {0}")
    public static Collection<Boolean[]> executionModes() {
        return Arrays.asList({false}, {true});
    }

    @Test
    public void testExceptionInInitializeOnMaster() throws Exception {
        FailingJobVertex failingJobVertex = new FailingJobVertex("Failing job vertex");
        failingJobVertex.setInvokableClass(NoOpInvokable.class);
        JobGraph failingJobGraph = new JobGraph("Failing testing job", new JobVertex[]{failingJobVertex});
        this.runJobSubmissionTest(failingJobGraph, e -> ExceptionUtils.findThrowable((Throwable)e, candidate -> "Test exception.".equals(candidate.getMessage())).isPresent());
    }

    @Test
    public void testSubmitEmptyJobGraph() throws Exception {
        JobGraph jobGraph = new JobGraph("Testing job");
        this.runJobSubmissionTest(jobGraph, e -> ExceptionUtils.findThrowable((Throwable)e, throwable -> throwable.getMessage() != null && throwable.getMessage().contains("empty")).isPresent());
    }

    @Test
    public void testMissingJarBlob() throws Exception {
        JobGraph jobGraph = JobSubmissionFailsITCase.getJobGraphWithMissingBlobKey();
        this.runJobSubmissionTest(jobGraph, e -> ExceptionUtils.findThrowable((Throwable)e, IOException.class).isPresent());
    }

    private void runJobSubmissionTest(JobGraph jobGraph, Predicate<Exception> failurePredicate) throws ProgramInvocationException {
        ClusterClient client;
        block4: {
            client = MINI_CLUSTER_RESOURCE.getClusterClient();
            try {
                if (this.detached) {
                    ClientUtils.submitJob((ClusterClient)client, (JobGraph)jobGraph);
                } else {
                    ClientUtils.submitJobAndWaitForResult((ClusterClient)client, (JobGraph)jobGraph, (ClassLoader)JobSubmissionFailsITCase.class.getClassLoader());
                }
                Assert.fail((String)"Job submission should have thrown an exception.");
            }
            catch (Exception e) {
                if (failurePredicate.test(e)) break block4;
                throw e;
            }
        }
        ClientUtils.submitJobAndWaitForResult((ClusterClient)client, (JobGraph)JobSubmissionFailsITCase.getWorkingJobGraph(), (ClassLoader)JobSubmissionFailsITCase.class.getClassLoader());
    }

    @Nonnull
    private static JobGraph getJobGraphWithMissingBlobKey() {
        JobGraph jobGraph = JobSubmissionFailsITCase.getWorkingJobGraph();
        jobGraph.addUserJarBlobKey(new PermanentBlobKey());
        return jobGraph;
    }

    private static class FailingJobVertex
    extends JobVertex {
        private static final long serialVersionUID = -6365291240199412135L;

        public FailingJobVertex(String msg) {
            super(msg);
        }

        public void initializeOnMaster(ClassLoader loader) throws Exception {
            throw new Exception("Test exception.");
        }
    }
}

