/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.TypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInfoFactory;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.types.PojoTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PojoTestUtilsTest {
    PojoTestUtilsTest() {
    }

    @Test
    void testNonPojoRejected() {
        Assertions.assertThatThrownBy(() -> PojoTestUtils.assertSerializedAsPojo(NoPojo.class)).isInstanceOf(AssertionError.class);
    }

    @Test
    void testPojoAccepted() {
        PojoTestUtils.assertSerializedAsPojo(Pojo.class);
    }

    @Test
    void testPojoAcceptedIfKryoRequired() {
        PojoTestUtils.assertSerializedAsPojo(PojoRequiringKryo.class);
    }

    @Test
    void testPojoTypeInfoOnInterface() {
        PojoTestUtils.assertSerializedAsPojo(Foo.class);
    }

    @Test
    void testWithoutKryoPojoAccepted() {
        PojoTestUtils.assertSerializedAsPojoWithoutKryo(Pojo.class);
    }

    @Test
    void testWithoutKryoPojoRejected() {
        Assertions.assertThatThrownBy(() -> PojoTestUtils.assertSerializedAsPojoWithoutKryo(PojoRequiringKryo.class)).isInstanceOf(AssertionError.class);
    }

    public static class FooFactory
    extends TypeInfoFactory<Foo> {
        public TypeInformation<Foo> createTypeInfo(Type type, Map<String, TypeInformation<?>> map) {
            return Types.POJO(Foo.class, new HashMap());
        }
    }

    @TypeInfo(value=FooFactory.class)
    public static interface Foo {
    }

    public static class PojoRequiringKryo {
        public List<?> x;
    }

    public static class Pojo {
        public int x;
    }

    private static class NoPojo {
        private NoPojo() {
        }
    }
}

