/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.util.Preconditions;

public class JobSubmission {
    private final Path jar;
    private final String mainClass;
    private final int parallelism;
    private final boolean detached;
    private final List<String> arguments;

    JobSubmission(Path jar, @Nullable String mainClass, int parallelism, boolean detached, List<String> arguments) {
        this.jar = jar;
        this.mainClass = mainClass;
        this.parallelism = parallelism;
        this.detached = detached;
        this.arguments = Collections.unmodifiableList(arguments);
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public boolean isDetached() {
        return this.detached;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public Path getJar() {
        return this.jar;
    }

    public Optional<String> getMainClass() {
        return Optional.ofNullable(this.mainClass);
    }

    public static class JobSubmissionBuilder {
        private final Path jar;
        private int parallelism = 0;
        private final List<String> arguments = new ArrayList<String>(2);
        private boolean detached = false;
        private String mainClass = null;

        public JobSubmissionBuilder(Path jar) {
            Preconditions.checkNotNull((Object)jar);
            Preconditions.checkArgument((boolean)jar.isAbsolute(), (Object)"Jar path must be absolute.");
            this.jar = jar;
        }

        public JobSubmissionBuilder setMainClass(String mainClass) {
            this.mainClass = mainClass;
            return this;
        }

        public JobSubmissionBuilder setParallelism(int parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        public JobSubmissionBuilder setDetached(boolean detached) {
            this.detached = detached;
            return this;
        }

        public JobSubmissionBuilder addArgument(String argument) {
            Preconditions.checkNotNull((Object)argument);
            this.arguments.add(argument);
            return this;
        }

        public JobSubmissionBuilder addArgument(String key, String value) {
            this.addArgument(key);
            this.addArgument(value);
            return this;
        }

        public JobSubmission build() {
            return new JobSubmission(this.jar, this.mainClass, this.parallelism, this.detached, this.arguments);
        }
    }
}

