/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.upserttest.sink;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.connector.upserttest.sink.ImmutableByteArrayWrapper;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;

@Internal
public class UpsertTestFileUtil {
    static final byte MAGIC_BYTE = 13;

    private UpsertTestFileUtil() {
    }

    public static void writeRecords(BufferedOutputStream bos, Map<ImmutableByteArrayWrapper, ImmutableByteArrayWrapper> records) throws IOException {
        Preconditions.checkNotNull((Object)bos);
        for (Map.Entry<ImmutableByteArrayWrapper, ImmutableByteArrayWrapper> record : records.entrySet()) {
            byte[] key = record.getKey().array();
            byte[] value = record.getValue().array();
            bos.write(13);
            bos.write(key.length);
            bos.write(key);
            bos.write(value.length);
            bos.write(value);
        }
        bos.flush();
    }

    public static int getNumberOfRecords(BufferedInputStream bis) throws IOException {
        Map<ImmutableByteArrayWrapper, ImmutableByteArrayWrapper> records = UpsertTestFileUtil.readRecords(bis);
        return records.size();
    }

    public static int getNumberOfRecords(File file) throws IOException {
        Preconditions.checkNotNull((Object)file);
        FileInputStream fs = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(fs);
        return UpsertTestFileUtil.getNumberOfRecords(bis);
    }

    public static <K, V> Map<K, V> readRecords(BufferedInputStream bis, DeserializationSchema<K> keyDeserializationSchema, DeserializationSchema<V> valueDeserializationSchema) throws IOException {
        Preconditions.checkNotNull((Object)bis);
        Map<ImmutableByteArrayWrapper, ImmutableByteArrayWrapper> bytesMap = UpsertTestFileUtil.readRecords(bis);
        HashMap typedMap = CollectionUtil.newHashMapWithExpectedSize((int)bytesMap.size());
        for (Map.Entry<ImmutableByteArrayWrapper, ImmutableByteArrayWrapper> entry : bytesMap.entrySet()) {
            Object key = keyDeserializationSchema.deserialize(entry.getKey().array());
            Object value = valueDeserializationSchema.deserialize(entry.getValue().array());
            typedMap.put(key, value);
        }
        return typedMap;
    }

    /*
     * Exception decompiling
     */
    public static <K, V> Map<K, V> readRecords(File file, DeserializationSchema<K> keyDeserializationSchema, DeserializationSchema<V> valueDeserializationSchema) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Map<ImmutableByteArrayWrapper, ImmutableByteArrayWrapper> readRecords(BufferedInputStream bis) throws IOException {
        int magicByte;
        Preconditions.checkNotNull((Object)bis);
        HashMap<ImmutableByteArrayWrapper, ImmutableByteArrayWrapper> records = new HashMap<ImmutableByteArrayWrapper, ImmutableByteArrayWrapper>();
        while ((magicByte = bis.read()) != -1) {
            if (magicByte != 13) {
                throw new IOException("Data was serialized incorrectly or is corrupted.");
            }
            int keyLength = bis.read();
            byte[] key = new byte[keyLength];
            bis.read(key);
            int valueLength = bis.read();
            byte[] value = new byte[valueLength];
            bis.read(value);
            records.put(new ImmutableByteArrayWrapper(key), new ImmutableByteArrayWrapper(value));
        }
        return records;
    }
}

